/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.chemical_reactor;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class ChemicalRecipeSerializer
extends IERecipeSerializer<ChemicalRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IIContent.IIMultiblocks.CRUCIBLE.blockItem().get());
    }

    public ChemicalRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext ctx) {
        FluidStack[] output_fluids;
        ItemStack[] outputs;
        FluidTagInput[] input_fluids;
        IngredientWithSize[] inputs;
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (Object je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = new IngredientWithSize[]{};
        }
        if (json.has("input_fluids")) {
            JsonArray ja = json.get("input_fluids").getAsJsonArray();
            input_fluids = new FluidTagInput[ja.size()];
            int i = -1;
            for (Object je : ja) {
                input_fluids[++i] = FluidTagInput.deserialize((JsonElement)je);
            }
        } else {
            input_fluids = new FluidTagInput[]{};
        }
        if (json.has("outputs")) {
            JsonArray ja = json.get("outputs").getAsJsonArray();
            outputs = new ItemStack[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                outputs[++i] = (ItemStack)ChemicalRecipeSerializer.readOutput((JsonElement)je).get();
            }
        } else {
            outputs = new ItemStack[]{};
        }
        if (json.has("result_fluids")) {
            JsonArray ja = json.get("result_fluids").getAsJsonArray();
            output_fluids = new FluidStack[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                output_fluids[++i] = ApiUtils.jsonDeserializeFluidStack((JsonObject)je.getAsJsonObject());
            }
        } else {
            output_fluids = new FluidStack[]{};
        }
        int time = 400;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = 32;
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        if (inputs.length == 0 && input_fluids.length == 0) {
            throw new JsonSyntaxException("Error loading chemical recipe " + recipeId + " because no input found");
        }
        if (outputs.length == 0 && output_fluids.length == 0) {
            throw new JsonSyntaxException("Error loading chemical recipe " + recipeId + " because no output found");
        }
        return new ChemicalRecipe(recipeId, outputs, output_fluids, inputs, input_fluids, time, tickEnergy);
    }

    @Nullable
    public ChemicalRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.m_130242_()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((FriendlyByteBuf)buffer);
        }
        FluidTagInput[] input_fluids = new FluidTagInput[buffer.m_130242_()];
        for (int i = 0; i < input_fluids.length; ++i) {
            input_fluids[i] = FluidTagInput.read((FriendlyByteBuf)buffer);
        }
        ItemStack[] outputs = new ItemStack[buffer.m_130242_()];
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = buffer.m_130267_();
        }
        FluidStack[] output_fluids = new FluidStack[buffer.m_130242_()];
        for (int i = 0; i < output_fluids.length; ++i) {
            output_fluids[i] = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        }
        int time = buffer.m_130242_();
        int tickEnergy = buffer.m_130242_();
        return new ChemicalRecipe(recipeId, outputs, output_fluids, inputs, input_fluids, time, tickEnergy);
    }

    public void toNetwork(FriendlyByteBuf buffer, ChemicalRecipe recipe) {
        buffer.m_130130_(recipe.inputs.length);
        for (IngredientWithSize ingredientWithSize : recipe.inputs) {
            ingredientWithSize.write(buffer);
        }
        buffer.m_130130_(recipe.input_fluids.length);
        for (IngredientWithSize ingredientWithSize : recipe.input_fluids) {
            ingredientWithSize.write(buffer);
        }
        buffer.m_130130_(recipe.outputs.length);
        for (IngredientWithSize ingredientWithSize : recipe.outputs) {
            buffer.m_130055_((ItemStack)ingredientWithSize);
        }
        buffer.m_130130_(recipe.output_fluids.length);
        for (IngredientWithSize ingredientWithSize : recipe.output_fluids) {
            ingredientWithSize.writeToPacket(buffer);
        }
        buffer.m_130130_(recipe.time);
        buffer.m_130130_(recipe.tickEnergy);
    }
}

