/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.chemical_reactor;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalState;
import com.teammoeg.immersiveindustry.util.FluidRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.FluidRecipeSimulator;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeSimulateHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class ChemicalRecipe
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<ChemicalRecipe>> SERIALIZER;
    public static CachedRecipeList<ChemicalRecipe> recipeList;
    public final IngredientWithSize[] inputs;
    public final FluidTagInput[] input_fluids;
    public final ItemStack[] outputs;
    public final FluidStack[] output_fluids;
    public final int time;
    public final int tickEnergy;

    public ChemicalRecipe(ResourceLocation id, ItemStack[] output2, FluidStack[] output_fluid, IngredientWithSize[] input, FluidTagInput[] input_fluids, int time, int tickEnergy) {
        super(Lazy.of(() -> ItemStack.f_41583_), IIContent.IIRecipes.CHEMICAL, id);
        this.outputs = output2;
        this.output_fluids = output_fluid;
        this.inputs = input;
        this.time = time;
        this.input_fluids = input_fluids;
        this.tickEnergy = tickEnergy;
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return ItemStack.f_41583_;
    }

    public static boolean isValidInput(Level l, ItemStack stack) {
        for (ChemicalRecipe recipe : recipeList.getRecipes(l)) {
            for (IngredientWithSize is : recipe.inputs) {
                if (!is.testIgnoringSize(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFuelTime(Level l, ItemStack stack) {
        return BlastFurnaceFuel.getBlastFuelTime((Level)l, (ItemStack)stack);
    }

    public static RecipeProcessResult<ChemicalRecipe> findRecipe(IMultiblockContext<ChemicalState> context) {
        return ChemicalRecipe.findRecipe(context.getLevel().getRawLevel(), (IItemHandler)((ChemicalState)context.getState()).inventory, ((ChemicalState)context.getState()).recipeInputFluidHandler);
    }

    public static RecipeProcessResult<ChemicalRecipe> findRecipe(Level l, IItemHandler handler, IFluidHandler tanks) {
        for (ChemicalRecipe recipe : recipeList.getRecipes(l)) {
            RecipeProcessResult<ChemicalRecipe> data = ChemicalRecipe.test(recipe, handler, tanks);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static RecipeProcessResult<ChemicalRecipe> executeRecipe(Level l, ResourceLocation rl, IItemHandler handler, IFluidHandler tanks) {
        return ChemicalRecipe.test((ChemicalRecipe)recipeList.getById(l, rl), handler, tanks);
    }

    public static RecipeProcessResult<ChemicalRecipe> test(ChemicalRecipe recipe, IItemHandler handler, IFluidHandler tanks) {
        int size = 0;
        for (int i = 0; i < 4; ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            ++size;
        }
        ItemRecipeProcessResult slotOps = null;
        if (recipe.inputs.length > 0) {
            if (recipe.inputs.length > size) {
                return null;
            }
            RecipeSimulateHelper helper = new RecipeSimulateHelper(handler, 0, 4);
            slotOps = helper.simulateExtract(recipe.inputs);
            if (slotOps == null) {
                return null;
            }
        }
        FluidRecipeProcessResult fluid = null;
        if (recipe.input_fluids.length > 0 && (fluid = FluidRecipeSimulator.test(tanks, recipe.input_fluids)) == null) {
            return null;
        }
        return new RecipeProcessResult<ChemicalRecipe>(recipe, slotOps, fluid);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (IngredientWithSize is : this.inputs) {
            nonnulllist.add((Object)is.getBaseIngredient());
        }
        return nonnulllist;
    }

    static {
        recipeList = new CachedRecipeList(IIContent.IIRecipes.CHEMICAL);
    }
}

