/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.chemical_reactor;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalRecipe;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.IIUtil;
import com.teammoeg.immersiveindustry.util.MultipleTankHandler;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.RegistryObject;

public class ChemicalLogic
implements IClientTickableComponent<ChemicalState>,
IMultiblockLogic<ChemicalState>,
IServerTickableComponent<ChemicalState> {
    static final CapabilityFacing[] out = new CapabilityFacing[]{new CapabilityFacing(2, 1, 1, RelativeBlockFace.LEFT), new CapabilityFacing(1, 1, 2, RelativeBlockFace.BACK), new CapabilityFacing(0, 1, 1, RelativeBlockFace.RIGHT)};
    static final CapabilityFacing[] in = new CapabilityFacing[]{new CapabilityFacing(2, 2, 1, RelativeBlockFace.LEFT), new CapabilityFacing(1, 2, 2, RelativeBlockFace.BACK), new CapabilityFacing(0, 2, 1, RelativeBlockFace.RIGHT)};
    static final CapabilityFacing itemout = new CapabilityFacing(1, 0, 1, RelativeBlockFace.DOWN);
    static final CapabilityFacing energy = new CapabilityFacing(1, 3, 1, RelativeBlockFace.UP);

    public void tickServer(IMultiblockContext<ChemicalState> context) {
        ChemicalState state = (ChemicalState)context.getState();
        if (this.tryOutput(context)) {
            context.markMasterDirty();
        }
        if (state.state.isEnabled(context)) {
            RecipeHandler<ChemicalRecipe> handler = state.recipe;
            ChangeDetectedItemHandler inventory = state.inventory;
            MultipleTankHandler fluidInput = state.recipeInputFluidHandler;
            if (handler.shouldTestRecipe()) {
                RecipeProcessResult<ChemicalRecipe> recipeResult = ChemicalRecipe.findRecipe(context);
                handler.setRecipe(recipeResult);
                context.markMasterDirty();
            }
            boolean lastActive = state.active;
            state.active = false;
            if (handler.shouldTickProcess()) {
                ChemicalRecipe rcp = (ChemicalRecipe)ChemicalRecipe.recipeList.getById(context.getLevel().getRawLevel(), handler.getLastRecipe());
                int energyConsume = (int)((double)rcp.tickEnergy * (Double)IIConfig.SERVER.chemicalBaseRate.get());
                if (state.energyStorage.extractEnergy(energyConsume, true) >= energyConsume && handler.tickProcess(1)) {
                    state.energyStorage.extractEnergy(energyConsume, false);
                    state.active = true;
                }
                if (handler.isRecipeFinished()) {
                    RecipeProcessResult<ChemicalRecipe> recipeResult = handler.getRecipeResultCache();
                    if (recipeResult != null) {
                        int num;
                        ChemicalRecipe recipe = recipeResult.recipe();
                        boolean isCompletable = true;
                        if (recipe.outputs.length > 0) {
                            num = 3;
                            for (ItemStack itemStack : recipe.outputs) {
                                if (inventory.insertItem(num++, itemStack, true).m_41619_()) continue;
                                isCompletable = false;
                                break;
                            }
                        }
                        if (isCompletable && recipe.output_fluids.length > 0) {
                            num = 0;
                            for (ItemStack itemStack : recipe.output_fluids) {
                                if (state.outTank[num++].fill((FluidStack)itemStack, IFluidHandler.FluidAction.SIMULATE) >= itemStack.getAmount()) continue;
                                isCompletable = false;
                                break;
                            }
                        }
                        if (isCompletable) {
                            if (recipe.outputs.length > 0) {
                                num = 3;
                                for (ItemStack itemStack : recipe.outputs) {
                                    inventory.insertItem(num++, itemStack.m_41777_(), false);
                                }
                            }
                            if (recipe.output_fluids.length > 0) {
                                num = 0;
                                for (ItemStack itemStack : recipe.output_fluids) {
                                    state.outTank[num++].fill(itemStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                                }
                            }
                            handler.endProcess();
                            recipeResult.runOperations((IItemHandlerModifiable)inventory, fluidInput);
                        }
                    } else {
                        handler.endProcess();
                    }
                }
                context.markMasterDirty();
            }
            if (state.active != lastActive) {
                context.requestMasterBESync();
            }
        }
    }

    public boolean tryOutput(IMultiblockContext<ChemicalState> context) {
        ChemicalState state = (ChemicalState)context.getState();
        boolean update = false;
        int num = 0;
        for (CapabilityReference<IFluidHandler> i : state.outputFluidCap) {
            update |= FluidUtils.multiblockFluidOutput(i, (FluidTank)state.outTank[num++], (int)0, (int)0, null);
        }
        if (context.getLevel().shouldTickModulo(8)) {
            ChangeDetectedItemHandler inventory = state.inventory;
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outputItemCap, 3);
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outputItemCap, 4);
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outputItemCap, 5);
        }
        return update;
    }

    public ChemicalState createInitialState(IInitialMultiblockContext<ChemicalState> capabilitySource) {
        return new ChemicalState(capabilitySource);
    }

    public void tickClient(IMultiblockContext<ChemicalState> context) {
        ChemicalState state = (ChemicalState)context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.mixer, (float)0.075f);
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<ChemicalState> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && position.posInMultiblock().m_123342_() == 3) {
            return ((ChemicalState)ctx.getState()).inputHandler.cast(ctx);
        }
        return ((ChemicalState)ctx.getState()).capabilities.getCapability(cap, position, ctx);
    }

    public void dropExtraItems(ChemicalState state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return t -> Shapes.m_83144_();
    }
}

