/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.chemical_reactor;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalRecipe;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalState;
import com.teammoeg.immersiveindustry.util.IIBaseContainer;
import com.teammoeg.immersiveindustry.util.IIContainerData;
import com.teammoeg.immersiveindustry.util.OutputSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ChemicalContainer
extends IIBaseContainer {
    IIContainerData.CustomDataSlot<Float> process = IIContainerData.SLOT_FIXED.create(this);
    IIContainerData.CustomDataSlot<Integer> process_num = IIContainerData.SLOT_INT.create(this);
    IIContainerData.CustomDataSlot<FluidStack>[] tanks = new IIContainerData.CustomDataSlot[6];
    FluidTank[] tank;
    IIContainerData.CustomDataSlot<Integer> energySlot;
    IIContainerData.CustomDataSlot<Boolean> active;
    MutableEnergyStorage energy;

    public ChemicalContainer(MenuType<ChemicalContainer> type, int windowId, Inventory inventoryPlayer, IEContainerMenu.MultiblockMenuContext<ChemicalState> te) {
        super(type, windowId, inventoryPlayer.f_35978_, 6);
        int i;
        for (int i2 = 0; i2 < this.tanks.length; ++i2) {
            this.tanks[i2] = IIContainerData.SLOT_TANK.create(this);
        }
        this.tank = new FluidTank[6];
        this.energySlot = IIContainerData.SLOT_INT.create(this);
        this.active = IIContainerData.SLOT_BOOL.create(this);
        ChemicalState state = (ChemicalState)te.mbContext().getState();
        this.process.bind(() -> Float.valueOf(state.recipe.getProgressRatio()));
        this.process_num.bind(state.recipe::getProcess);
        int num = 0;
        for (FluidTank curtank : state.inTank) {
            i = num++;
            this.tank[i] = curtank;
            this.tanks[i].bind(() -> ((FluidTank)curtank).getFluid());
        }
        for (FluidTank curtank : state.outTank) {
            i = num++;
            this.tank[i] = curtank;
            this.tanks[i].bind(() -> ((FluidTank)curtank).getFluid());
        }
        this.addSlots((IItemHandlerModifiable)state.inventory, inventoryPlayer);
        this.energy = state.energyStorage;
        this.energySlot.bind(() -> ((MutableEnergyStorage)this.energy).getEnergyStored());
        this.active.bind(() -> state.active);
    }

    public ChemicalContainer(MenuType<ChemicalContainer> type, int windowId, Inventory inventoryPlayer) {
        super(type, windowId, inventoryPlayer.f_35978_, 6);
        int i;
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = IIContainerData.SLOT_TANK.create(this);
        }
        this.tank = new FluidTank[6];
        this.energySlot = IIContainerData.SLOT_INT.create(this);
        this.active = IIContainerData.SLOT_BOOL.create(this);
        this.addSlots((IItemHandlerModifiable)new ItemStackHandler(6), inventoryPlayer);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tank[i] = new FluidTank(7000);
            this.tanks[i].bind(arg_0 -> ((FluidTank)this.tank[i]).setFluid(arg_0));
        }
        this.energy = new MutableEnergyStorage(32000);
        this.energySlot.bind(arg_0 -> ((MutableEnergyStorage)this.energy).setStoredEnergy(arg_0));
    }

    public void addSlots(IItemHandlerModifiable inv, Inventory inventoryPlayer) {
        Level l = inventoryPlayer.f_35978_.m_9236_();
        this.m_38897_((Slot)new ChemicalSlot((IItemHandler)inv, 0, 11, 77, l));
        this.m_38897_((Slot)new ChemicalSlot((IItemHandler)inv, 1, 34, 77, l));
        this.m_38897_((Slot)new ChemicalSlot((IItemHandler)inv, 2, 57, 77, l));
        this.m_38897_((Slot)new OutputSlot(inv, 3, 181, 77));
        this.m_38897_((Slot)new OutputSlot(inv, 4, 205, 77));
        this.m_38897_((Slot)new OutputSlot(inv, 5, 229, 77));
        super.addPlayerInventory(inventoryPlayer, 48, 112, 170);
    }

    static class ChemicalSlot
    extends SlotItemHandler {
        Level l;

        public ChemicalSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Level l) {
            super(itemHandler, index, xPosition, yPosition);
            this.l = l;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return ChemicalRecipe.isValidInput(this.l, itemStack);
        }
    }
}

