/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class CarKilnRecipeSerializer
extends IERecipeSerializer<CarKilnRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IIContent.IIMultiblocks.CAR_KILN.blockItem().get());
    }

    @Nullable
    public CarKilnRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int outs = buffer.m_130242_();
        ItemStack[] output = new ItemStack[outs];
        for (int i = 0; i < outs; ++i) {
            output[i] = buffer.m_130267_();
        }
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.m_130242_()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((FriendlyByteBuf)buffer);
        }
        FluidTagInput input_fluid = null;
        if (buffer.readBoolean()) {
            input_fluid = FluidTagInput.read((FriendlyByteBuf)buffer);
        }
        int time = buffer.m_130242_();
        int tickEnergy = buffer.m_130242_();
        return new CarKilnRecipe(recipeId, output, inputs, input_fluid, time, tickEnergy);
    }

    public void toNetwork(FriendlyByteBuf buffer, CarKilnRecipe recipe) {
        buffer.m_130130_(recipe.output.length);
        for (int i = 0; i < recipe.output.length; ++i) {
            buffer.m_130055_(recipe.output[i]);
        }
        buffer.m_130130_(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        if (recipe.input_fluid != null) {
            buffer.writeBoolean(true);
            recipe.input_fluid.write(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130130_(recipe.time);
        buffer.m_130130_(recipe.tickEnergy);
    }

    public CarKilnRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        IngredientWithSize[] inputs;
        ItemStack[] output;
        if (json.has("results")) {
            JsonArray ja = json.get("results").getAsJsonArray();
            ArrayList<ItemStack> ops = new ArrayList<ItemStack>();
            for (Object je : ja) {
                ops.add((ItemStack)CarKilnRecipeSerializer.readOutput((JsonElement)je).get());
            }
            output = ops.toArray(new ItemStack[0]);
        } else {
            output = new ItemStack[]{(ItemStack)CarKilnRecipeSerializer.readOutput((JsonElement)json.get("result")).get()};
        }
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = json.has("input") ? new IngredientWithSize[]{IngredientWithSize.deserialize((JsonElement)json.get("input"))} : new IngredientWithSize[]{};
        }
        FluidTagInput input_fluid = null;
        if (json.has("input_fluid")) {
            input_fluid = FluidTagInput.deserialize((JsonElement)json.get("input_fluid"));
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = 32;
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        return new CarKilnRecipe(recipeId, output, inputs, input_fluid, time, tickEnergy);
    }
}

