/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnState;
import com.teammoeg.immersiveindustry.util.FluidRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.FluidRecipeSimulator;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeSimulateHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class CarKilnRecipe
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<CarKilnRecipe>> SERIALIZER;
    public final IngredientWithSize[] inputs;
    public final ItemStack[] output;
    public final FluidTagInput input_fluid;
    public final int time;
    public final int tickEnergy;
    public int maxProcess;
    public static CachedRecipeList<CarKilnRecipe> recipeList;

    public CarKilnRecipe(ResourceLocation id, ItemStack[] output, IngredientWithSize[] inputs, FluidTagInput input_fluid, int time, int tickEnergy) {
        super(Lazy.of(() -> output[0]), IIContent.IIRecipes.CAR_KILN, id);
        this.output = output;
        this.inputs = inputs;
        this.input_fluid = input_fluid;
        this.time = time;
        this.tickEnergy = tickEnergy;
        this.maxProcess = 64;
        for (ItemStack out : output) {
            this.maxProcess = Math.min(this.maxProcess, out.m_41741_() / out.m_41613_());
        }
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getInputAmount() {
        int total = 0;
        for (IngredientWithSize iws : this.inputs) {
            total += iws.getCount();
        }
        return total;
    }

    public static boolean isValidInput(Level l, ItemStack stack) {
        for (CarKilnRecipe recipe : recipeList.getRecipes(l)) {
            for (IngredientWithSize is : recipe.inputs) {
                if (!is.testIgnoringSize(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static RecipeProcessResult<CarKilnRecipe> findRecipe(IMultiblockContext<CarKilnState> context) {
        return CarKilnRecipe.findRecipe(context.getLevel().getRawLevel(), (IItemHandler)((CarKilnState)context.getState()).inventory, (IFluidHandler)((CarKilnState)context.getState()).tank);
    }

    public static RecipeProcessResult<CarKilnRecipe> findRecipe(Level l, IItemHandler input, IFluidHandler input_fluid) {
        for (CarKilnRecipe recipe : recipeList.getRecipes(l)) {
            RecipeProcessResult<CarKilnRecipe> data = CarKilnRecipe.test(recipe, input, input_fluid);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static RecipeProcessResult<CarKilnRecipe> executeRecipe(Level l, ResourceLocation rl, IItemHandler input, IFluidHandler input_fluid) {
        return CarKilnRecipe.test((CarKilnRecipe)recipeList.getById(l, rl), input, input_fluid);
    }

    public static RecipeProcessResult<CarKilnRecipe> test(CarKilnRecipe recipe, IItemHandler input, IFluidHandler tanks) {
        int size = 0;
        for (int i = 0; i < 4; ++i) {
            if (input.getStackInSlot(i).m_41619_()) continue;
            ++size;
        }
        ItemRecipeProcessResult slotOps = null;
        if (recipe.inputs.length > 0) {
            if (recipe.inputs.length > size) {
                return null;
            }
            RecipeSimulateHelper helper = new RecipeSimulateHelper(input, 0, 4);
            slotOps = helper.simulateExtract(recipe.inputs);
            if (slotOps == null) {
                return null;
            }
        }
        FluidRecipeProcessResult fluid = null;
        if (recipe.input_fluid != null && (fluid = FluidRecipeSimulator.test(tanks, recipe.input_fluid)) == null) {
            return null;
        }
        return new RecipeProcessResult<CarKilnRecipe>(recipe, slotOps, fluid);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (IngredientWithSize is : this.inputs) {
            nonnulllist.add((Object)is.getBaseIngredient());
        }
        return nonnulllist;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output[0];
    }

    static {
        recipeList = new CachedRecipeList(IIContent.IIRecipes.CAR_KILN);
    }
}

