/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.IIUtil;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class CarKilnLogic
implements IMultiblockLogic<CarKilnState>,
IClientTickableComponent<CarKilnState>,
IServerTickableComponent<CarKilnState> {
    public static final CapabilityFacing[] outputItemCaps = new CapabilityFacing[]{new CapabilityFacing(0, 0, 4, RelativeBlockFace.BACK), new CapabilityFacing(1, 0, 4, RelativeBlockFace.BACK), new CapabilityFacing(2, 0, 4, RelativeBlockFace.BACK)};
    public static final CapabilityFacing[] inputItemCaps = new CapabilityFacing[]{new CapabilityFacing(0, 1, 4, RelativeBlockFace.RIGHT), new CapabilityFacing(2, 1, 4, RelativeBlockFace.LEFT)};
    public static final CapabilityFacing inputFluidCap = new CapabilityFacing(1, 3, 0, RelativeBlockFace.FRONT);
    public static final CapabilityFacing inputEnergyCap = new CapabilityFacing(1, 1, 0, RelativeBlockFace.FRONT);
    static final Function<BlockPos, VoxelShape> shapeCache = Util.m_143827_(CarKilnLogic::getShape);

    public void tickServer(IMultiblockContext<CarKilnState> context) {
        CarKilnState state = (CarKilnState)context.getState();
        ChangeDetectedItemHandler inventory = state.inventory;
        this.tryOutput(context);
        boolean shouldEarlyExit = false;
        for (int i = 0; i < state.result.getSlots(); ++i) {
            ItemStack cur = state.result.getStackInSlot(i);
            if (cur.m_41619_()) continue;
            shouldEarlyExit = true;
            state.result.setStackInSlot(i, ItemHandlerHelper.insertItem((IItemHandler)state.resultwrap, (ItemStack)cur, (boolean)false));
        }
        if (!shouldEarlyExit && state.state.isEnabled(context)) {
            RecipeHandler<CarKilnRecipe> handler = state.recipe;
            if (handler.shouldTestRecipe()) {
                RecipeProcessResult<CarKilnRecipe> recipeResult = CarKilnRecipe.findRecipe(context);
                if (handler.setRecipe(recipeResult)) {
                    state.maxProcessCount = 0;
                }
                if (recipeResult != null) {
                    state.maxProcessCount = 64;
                    state.maxProcessCount = Math.min(Math.min(recipeResult.getMaxRuns((IItemHandlerModifiable)inventory, (IFluidHandler)state.tank), recipeResult.recipe().maxProcess), state.maxProcessCount);
                }
                context.markDirtyAndSync();
            }
            boolean lastActive = state.active;
            state.active = false;
            if (handler.shouldTickProcess()) {
                CarKilnRecipe rcp = (CarKilnRecipe)CarKilnRecipe.recipeList.getById(context.getLevel().getRawLevel(), handler.getLastRecipe());
                int energyConsume = (int)((double)rcp.tickEnergy * (Double)IIConfig.SERVER.carKilnBaseRate.get());
                if (state.energyStorage.extractEnergy(energyConsume, true) >= energyConsume && handler.tickProcess(1)) {
                    state.energyStorage.extractEnergy(energyConsume, false);
                    state.active = true;
                    int ptm = handler.getProcess();
                    int process = handler.getFinishedProgress();
                    int lastProcess = state.pos;
                    state.pos = process < 53 ? process : (ptm < 53 ? ptm : 52);
                    if (lastProcess != state.pos) {
                        context.requestMasterBESync();
                    }
                    context.markMasterDirty();
                }
                if (handler.isRecipeFinished()) {
                    RecipeProcessResult<CarKilnRecipe> recipeResult = handler.getRecipeResultCache();
                    if (recipeResult != null) {
                        CarKilnRecipe recipe = recipeResult.recipe();
                        recipeResult.runOperations((IItemHandlerModifiable)inventory, (IFluidHandler)state.tank, state.maxProcessCount);
                        for (ItemStack output : recipe.output) {
                            ItemHandlerHelper.insertItem((IItemHandler)state.result, (ItemStack)output.m_255036_(output.m_41613_() * state.maxProcessCount), (boolean)false);
                        }
                        handler.endProcess();
                        state.maxProcessCount = 0;
                        context.markDirtyAndSync();
                    } else {
                        handler.endProcess();
                        state.maxProcessCount = 0;
                    }
                }
                context.markMasterDirty();
            } else if (state.pos > 0) {
                --state.pos;
                state.maxProcessCount = 0;
                context.markDirtyAndSync();
            }
            if (state.active != lastActive) {
                context.requestMasterBESync();
            }
        }
    }

    public void tickClient(IMultiblockContext<CarKilnState> context) {
        CarKilnState state = (CarKilnState)context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.arcFurnace, (float)0.075f);
        }
    }

    public CarKilnState createInitialState(IInitialMultiblockContext<CarKilnState> capabilitySource) {
        return new CarKilnState(capabilitySource);
    }

    static VoxelShape getShape(BlockPos pos) {
        if (pos.m_123343_() < 4 && pos.m_123342_() < 2) {
            return Shapes.m_83144_();
        }
        if (pos.m_123342_() == 3 && pos.m_123341_() == 1 && pos.m_123343_() == 0) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.5, (double)0.875, (double)0.875, (double)1.0));
        }
        if (pos.m_123342_() == 2 && pos.m_123341_() == 1 && pos.m_123343_() == 0) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.0625, (double)0.6825, (double)1.0, (double)0.4375));
        }
        if (pos.m_123342_() == 3 && pos.m_123341_() == 1 && pos.m_123343_() == 1) {
            return Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
        }
        if (pos.m_123342_() == 2 && pos.m_123341_() == 1 && pos.m_123343_() == 1) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
        }
        VoxelShape base = pos.m_123342_() == 2 ? Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0) : (pos.m_123342_() == 0 ? Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0) : Shapes.m_83040_());
        if (pos.m_123342_() >= 2) {
            if (pos.m_123341_() == 0) {
                base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0));
            } else if (pos.m_123341_() == 2) {
                base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0));
            }
            if (pos.m_123343_() == 3) {
                base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
                if (pos.m_123342_() == 4) {
                    base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)1.0));
                }
            }
        }
        if (pos.m_123343_() == 4) {
            if (pos.m_123341_() == 0) {
                base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0));
            } else if (pos.m_123341_() == 2) {
                base = Shapes.m_83110_((VoxelShape)base, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
            }
        }
        return base;
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return shapeCache;
    }

    public boolean tryOutput(IMultiblockContext<CarKilnState> context) {
        CarKilnState state = (CarKilnState)context.getState();
        boolean update = false;
        if (context.getLevel().shouldTickModulo(16)) {
            ChangeDetectedItemHandler inventory = state.inventory;
            for (CapabilityReference<IItemHandler> c : state.outputItemCap) {
                if (!c.isPresent()) continue;
                update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, c, 4);
                update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, c, 5);
                update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, c, 6);
                update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, c, 7);
                update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, c, 8);
            }
        }
        return update;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<CarKilnState> ctx, CapabilityPosition position, Capability<T> cap) {
        return ((CarKilnState)ctx.getState()).capabilities.getCapability(cap, position, ctx);
    }

    public void dropExtraItems(CarKilnState state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
        MBInventoryUtils.dropItems((IItemHandler)state.result, drop);
    }
}

