/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnState;
import com.teammoeg.immersiveindustry.util.IIBaseContainer;
import com.teammoeg.immersiveindustry.util.IIContainerData;
import com.teammoeg.immersiveindustry.util.OutputSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CarKilnContainer
extends IIBaseContainer {
    IIContainerData.CustomDataSlot<FluidStack> tankSlot = IIContainerData.SLOT_TANK.create(this);
    IIContainerData.CustomDataSlot<Float> process = IIContainerData.SLOT_FIXED.create(this);
    IIContainerData.CustomDataSlot<Integer> energySlot = IIContainerData.SLOT_INT.create(this);
    FluidTank tank;
    MutableEnergyStorage energy;
    public static final TagKey<Item> Electrode_Tag = ItemTags.create((ResourceLocation)new ResourceLocation("immersiveindustry", "electrodes"));

    public CarKilnContainer(MenuType<CarKilnContainer> type, int windowId, Inventory inventoryPlayer, IEContainerMenu.MultiblockMenuContext<CarKilnState> te) {
        super(type, windowId, inventoryPlayer.f_35978_, 9);
        CarKilnState state = (CarKilnState)te.mbContext().getState();
        this.process.bind(() -> Float.valueOf(state.recipe.getProgressRatio()));
        this.tank = state.tank;
        this.tankSlot.bind(() -> this.tank.getFluid());
        this.energy = state.energyStorage;
        this.energySlot.bind(() -> this.energy.getEnergyStored());
        this.addSlots((IItemHandlerModifiable)state.inventory, inventoryPlayer);
    }

    public CarKilnContainer(MenuType<CarKilnContainer> type, int windowId, Inventory inventoryPlayer) {
        super(type, windowId, inventoryPlayer.f_35978_, 9);
        this.addSlots((IItemHandlerModifiable)new ItemStackHandler(9), inventoryPlayer);
        this.tank = new FluidTank(16000);
        this.tankSlot.bind(t -> this.tank.setFluid(t));
        this.energy = new MutableEnergyStorage(32000);
        this.energySlot.bind(t -> this.energy.setStoredEnergy(t.intValue()));
    }

    public void addSlots(IItemHandlerModifiable inv, Inventory inventoryPlayer) {
        int i;
        Level l = inventoryPlayer.f_35978_.m_9236_();
        for (i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new InputSlot((IItemHandler)inv, i, 35 + i % 2 * 18, 21 + i / 2 * 18, l));
        }
        for (i = 0; i < 5; ++i) {
            this.m_38897_((Slot)new OutputSlot(inv, 4 + i, 96 + i % 3 * 18, 50 + i / 3 * 18));
        }
        super.addPlayerInventory(inventoryPlayer, 8, 96, 154);
    }

    private static class InputSlot
    extends SlotItemHandler {
        Level l;

        public InputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Level l) {
            super(itemHandler, index, xPosition, yPosition);
            this.l = l;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return CarKilnRecipe.isValidInput(this.l, itemStack);
        }
    }
}

