/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.util.JEISlotBuilder;
import com.teammoeg.immersiveindustry.util.LangUtil;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CarKilnCategory
implements IRecipeCategory<CarKilnRecipe> {
    public static RecipeType<CarKilnRecipe> UID = new RecipeType(new ResourceLocation("immersiveindustry", "car_kiln"), CarKilnRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;
    private IDrawable TANK;
    private IDrawableAnimated ARROW;

    public CarKilnCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)IIContent.IIMultiblocks.CAR_KILN.blockItem().get()));
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/car_kiln.png"), 6, 16, 143, 71);
        this.TANK = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/car_kiln.png"), 197, 1, 18, 48);
        IDrawableStatic arrow = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/car_kiln.png"), 177, 57, 37, 17);
        this.ARROW = guiHelper.createAnimatedDrawable(arrow, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CarKilnRecipe> getRecipeType() {
        return UID;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CarKilnRecipe recipe, IFocusGroup focuses) {
        JEISlotBuilder<ItemStack> itemInput = JEISlotBuilder.itemStack(builder, JEIIngredientStackListBuilder.make((IngredientWithSize[])recipe.inputs).build()).asInput();
        for (int i = 0; i < 4; ++i) {
            itemInput.addSlot(29 + i % 2 * 18, 5 + i / 2 * 18);
        }
        JEISlotBuilder<ItemStack> itemOutput = JEISlotBuilder.itemStack(builder, recipe.output).asOutput();
        for (int i = 0; i < 5; ++i) {
            itemOutput.addSlot(90 + i % 3 * 18, 34 + i / 3 * 18);
        }
        IRecipeSlotBuilder fluidSlot = builder.addSlot(RecipeIngredientRole.INPUT, 4, 10).setFluidRenderer(3200L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        if (recipe.input_fluid != null) {
            fluidSlot.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.input_fluid.getMatchingFluidStacks());
        }
    }

    public void draw(CarKilnRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.ARROW.draw(guiGraphics, 77, 13);
    }

    public Component getTitle() {
        return LangUtil.translate("gui.jei.category.immersiveindustry.car_kiln", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }
}

