/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.compat;

import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.compat.JEIGuiContainerHandler;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnCategory;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnScreen;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalCategory;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalRecipe;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalScreen;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleCategory;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerCategory;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerCategory;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnCategory;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnScreen;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("immersiveindustry", "jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIBlocks.burning_chamber.get()), new RecipeType[]{CrucibleCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIBlocks.electrolyzer.get()), new RecipeType[]{ElectrolyzerCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIMultiblocks.INDUSTRIAL_ELECTROLYZER.blockItem().get()), new RecipeType[]{IndustrialElectrolyzerCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIMultiblocks.ROTARY_KILN.blockItem().get()), new RecipeType[]{RotaryKilnCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIMultiblocks.CAR_KILN.blockItem().get()), new RecipeType[]{CarKilnCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IIContent.IIMultiblocks.CHEMICAL_REACTOR.blockItem().get()), new RecipeType[]{ChemicalCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        JEICompat.checkNotNull(world, "minecraft world");
        registration.addRecipes(CrucibleCategory.UID, new ArrayList(CrucibleRecipe.recipeList.getRecipes((Level)world)));
        registration.addRecipes(ElectrolyzerCategory.UID, ElectrolyzerRecipe.recipeList.getRecipes((Level)world).stream().filter(r -> !r.flag).filter(r -> r.inputs.length < 2).collect(Collectors.toList()));
        registration.addRecipes(IndustrialElectrolyzerCategory.UID, ElectrolyzerRecipe.recipeList.getRecipes((Level)world).stream().filter(r -> r.inputs.length < 3).collect(Collectors.toList()));
        registration.addRecipes(RotaryKilnCategory.UID, new ArrayList(RotaryKilnRecipe.recipeList.getRecipes((Level)world)));
        registration.addRecipes(CarKilnCategory.UID, new ArrayList(CarKilnRecipe.recipeList.getRecipes((Level)world)));
        registration.addRecipes(ChemicalCategory.UID, new ArrayList(ChemicalRecipe.recipeList.getRecipes((Level)world)));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleCategory(guiHelper), new ElectrolyzerCategory(guiHelper), new IndustrialElectrolyzerCategory(guiHelper), new RotaryKilnCategory(guiHelper), new CarKilnCategory(guiHelper), new ChemicalCategory(guiHelper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        IIngredientManager man = registry.getJeiHelpers().getIngredientManager();
        registry.addGenericGuiContainerHandler(ElectrolyzerScreen.class, new JEIGuiContainerHandler(man, 76, 35, 21, 25, ElectrolyzerCategory.UID));
        registry.addGenericGuiContainerHandler(IndustrialElectrolyzerScreen.class, new JEIGuiContainerHandler(man, 76, 35, 21, 25, IndustrialElectrolyzerCategory.UID));
        registry.addGenericGuiContainerHandler(CrucibleScreen.class, new JEIGuiContainerHandler(man, 76, 14, 19, 25, CrucibleCategory.UID));
        registry.addGenericGuiContainerHandler(RotaryKilnScreen.class, new JEIGuiContainerHandler(man, 92, 41, 35, 18, RotaryKilnCategory.UID));
        registry.addGenericGuiContainerHandler(CarKilnScreen.class, new JEIGuiContainerHandler(man, 82, 25, 40, 18, CarKilnCategory.UID));
        registry.addGenericGuiContainerHandler(ChemicalScreen.class, new JEIGuiContainerHandler(man, 98, 0, 63, 104, ChemicalCategory.UID));
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }
}

