/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class IIConfig {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        SERVER = new Server(COMMON_BUILDER);
        SERVER_CONFIG = COMMON_BUILDER.build();
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue electrolyzerBaseRate;
        public final ForgeConfigSpec.DoubleValue rotaryKilnBaseRate;
        public final ForgeConfigSpec.DoubleValue carKilnBaseRate;
        public final ForgeConfigSpec.DoubleValue crucibleCoolDown;
        public final ForgeConfigSpec.DoubleValue steamTurbineGenerator;
        public final ForgeConfigSpec.DoubleValue steamTurbineSaturationRate;
        public final ForgeConfigSpec.DoubleValue steamTurbineUnsaturationRate;
        public final ForgeConfigSpec.DoubleValue steamTurbineSaturationMin;
        public final ForgeConfigSpec.DoubleValue steamTurbineSaturationMax;
        public final ForgeConfigSpec.IntValue steamTurbineInputMin;
        public final ForgeConfigSpec.IntValue steamTurbineInputMax;
        public final ForgeConfigSpec.DoubleValue electrodeCost;
        public final ForgeConfigSpec.DoubleValue chemicalBaseRate;

        Server(ForgeConfigSpec.Builder builder) {
            this.electrolyzerBaseRate = builder.defineInRange("ElectrolyzerBaseTickEnergyRate", 1.0, 0.0, 2.147483647E9);
            this.rotaryKilnBaseRate = builder.defineInRange("RotaryKilnBaseTickEnergyRate", 1.0, 0.0, 2.147483647E9);
            this.carKilnBaseRate = builder.defineInRange("CarKilnBaseTickEnergyRate", 1.0, 0.0, 2.147483647E9);
            this.steamTurbineGenerator = builder.defineInRange("SteamTurbineGeneratePerSteam", 16.0, 0.0, 2.147483647E9);
            this.steamTurbineSaturationRate = builder.defineInRange("SteamTurbineSaturationPerSteam", 2.0E-6, 0.0, 1.0);
            this.steamTurbineUnsaturationRate = builder.defineInRange("SteamTurbineUnsaturationPerTickPerLevel", 2.4E-4, 0.0, 1.0);
            this.steamTurbineSaturationMin = builder.defineInRange("SteamTurbineMinimumSaturation", 0.4, 0.0, 100000.0);
            this.steamTurbineSaturationMax = builder.defineInRange("SteamTurbineMaximumSaturation", 4.0, 0.0, 100000.0);
            this.steamTurbineInputMax = builder.defineInRange("SteamTurbineMaximumInput", 288, 0, Integer.MAX_VALUE);
            this.steamTurbineInputMin = builder.defineInRange("SteamTurbineMinimumInput", 48, 0, Integer.MAX_VALUE);
            this.electrodeCost = builder.defineInRange("ElectrodeCost", 0.25, 0.0, 96000.0);
            this.crucibleCoolDown = builder.defineInRange("CrucibleCooldownRate", 0.25, 0.0, 2.147483647E9);
            this.chemicalBaseRate = builder.defineInRange("ChemicalReactorBaseTickEnergyRate", 1.0, 0.0, 2.147483647E9);
        }
    }
}

