/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import com.teammoeg.immersiveindustry.mixin.MixinIETemplateMultiblockAccess;
import com.teammoeg.immersiveindustry.mixin.MixinMultiblockPartBlockAccess;
import com.teammoeg.immersiveindustry.mixin.MixinTemplateMultiblockAccess;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveindustry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    public static ResourceLocation multiblockCache = null;
    public static Rotation rotCache = null;
    public static AABB multiblockBound = null;

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item2;
        Block block = blockItem.m_40614_();
        if (block instanceof MixinMultiblockPartBlockAccess) {
            MixinMultiblockPartBlockAccess block2 = (MixinMultiblockPartBlockAccess)block;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            Level level = event.getLevel();
            if (level.m_5776_()) {
                return;
            }
            BlockHitResult hitResult = event.getHitVec();
            MultiblockRegistration<?> multiblockReg = block2.getMultiblock();
            IETemplateMultiblock multiblock = ForgeEvents.getITEMFromReg(multiblockReg);
            BlockPos pos = hitResult.m_82425_();
            if (multiblock == null) {
                ForgeEvents.formMultiblockOld(level, pos, multiblockReg);
            } else {
                BlockPos placePos = pos.m_6630_(multiblock.getMasterFromOriginOffset().m_123342_());
                Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)Direction.NORTH, (Direction)event.getEntity().m_6350_());
                ((MixinTemplateMultiblockAccess)multiblock).callForm(level, placePos, rot, Mirror.NONE, event.getEntity().m_6350_().m_122424_());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ItemStack itemInOffHand = event.player.m_21206_();
        ItemStack itemInMainHand = event.player.m_21205_();
        if (!ForgeEvents.updateMultiblockInHand(event.player, itemInMainHand) && !ForgeEvents.updateMultiblockInHand(event.player, itemInOffHand)) {
            multiblockCache = null;
            rotCache = null;
            multiblockBound = null;
        }
    }

    public static boolean updateMultiblockInHand(Player player, ItemStack itemStack) {
        BlockItem blockItem;
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof MixinMultiblockPartBlockAccess) {
            MixinMultiblockPartBlockAccess block = (MixinMultiblockPartBlockAccess)item;
            IETemplateMultiblock multiblock = ForgeEvents.getITEMFromReg(block.getMultiblock());
            Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)Direction.NORTH, (Direction)player.m_6350_());
            if (multiblock != null && (rot != rotCache || multiblock.getUniqueName().equals((Object)multiblockCache))) {
                multiblockCache = multiblock.getUniqueName();
                rotCache = rot;
                multiblockBound = ForgeEvents.getStructureOutBounds(player.m_9236_(), multiblock, rot, Mirror.NONE);
            }
            return true;
        }
        return false;
    }

    public static AABB getStructureOutBounds(Level level, IETemplateMultiblock multiblock, Rotation rot, Mirror mirror) {
        return new AABB(BlockPos.f_121853_, TemplateMultiblock.getAbsoluteOffset((BlockPos)new BlockPos(multiblock.getSize(level)), (Mirror)mirror, (Rotation)rot));
    }

    public static void formMultiblockOld(Level level, BlockPos pos, MultiblockRegistration<?> multiblockReg) {
        List structure = (List)multiblockReg.getStructure().apply(level);
        for (StructureTemplate.StructureBlockInfo aBlock : structure) {
            BlockEntity be;
            BlockPos pos_ = aBlock.f_74675_().m_121955_((Vec3i)pos);
            if (aBlock.f_74677_() != null) {
                BlockEntity blockentity = level.m_7702_(pos_);
                Clearable.m_18908_((Object)blockentity);
                level.m_7731_(pos_, Blocks.f_50375_.m_49966_(), 20);
            }
            if (!level.m_7731_(pos_, aBlock.f_74676_(), 3) || aBlock.f_74677_() == null || (be = level.m_7702_(pos_)) == null) continue;
            be.m_142466_(aBlock.f_74677_());
            be.m_6596_();
        }
    }

    @Nullable
    public static IETemplateMultiblock getITEMFromReg(MultiblockRegistration<?> multiblockReg) {
        for (MultiblockHandler.IMultiblock imb : MultiblockHandler.getMultiblocks()) {
            MixinIETemplateMultiblockAccess ietm;
            if (!(imb instanceof MixinIETemplateMultiblockAccess) || !(ietm = (MixinIETemplateMultiblockAccess)imb).getLogic().equals(multiblockReg)) continue;
            return (IETemplateMultiblock)ietm;
        }
        return null;
    }
}

