/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRenderer;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnScreen;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalScreen;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerRenderer;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRenderer;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnScreen;
import com.teammoeg.immersiveindustry.util.DynamicBlockModelReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="immersiveindustry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistryEvents {
    private static Tree.InnerNode<ResourceLocation, ManualEntry> CATEGORY;
    public static final Map<String, Supplier<Object>> extras;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)IIContent.IIMenus.ELECTROLYZER.get()), ElectrolyzerScreen::new);
        MenuScreens.m_96206_(IIContent.IIMenus.ROTARY_KILN.getType(), RotaryKilnScreen::new);
        MenuScreens.m_96206_(IIContent.IIMenus.INDUSTRIAL_ELECTROLYZER.getType(), IndustrialElectrolyzerScreen::new);
        MenuScreens.m_96206_(IIContent.IIMenus.CAR_KILN.getType(), CarKilnScreen::new);
        MenuScreens.m_96206_(IIContent.IIMenus.CRUCIBLE.getType(), CrucibleScreen::new);
        MenuScreens.m_96206_(IIContent.IIMenus.CHEMICAL.getType(), ChemicalScreen::new);
        ClientRegistryEvents.addManual();
    }

    @SubscribeEvent
    public static void registerBERenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)IIContent.IIMultiblocks.INDUSTRIAL_ELECTROLYZER.masterBE().get(), IndustrialElectrolyzerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)IIContent.IIMultiblocks.ROTARY_KILN.masterBE().get(), RotaryKilnRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)IIContent.IIMultiblocks.CAR_KILN.masterBE().get(), CarKilnRenderer::new);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional ev) {
        DynamicBlockModelReference.registeredModels.forEach(rl -> ev.register(rl));
    }

    public static void addManual() {
        ManualInstance man = ManualHelper.getManual();
        CATEGORY = man.getRoot().getOrCreateSubnode((Comparable)new ResourceLocation("immersiveindustry", "main"), 100);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("crucible", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.CRUCIBLE.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "crucible"));
        man.addEntry(CATEGORY, builder.create(), 0);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.readFromFile(new ResourceLocation("immersiveindustry", "electrolyzer"));
        man.addEntry(CATEGORY, builder.create(), 1);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("industrial_electrolyzer", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.INDUSTRIAL_ELECTROLYZER.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "industrial_electrolyzer"));
        man.addEntry(CATEGORY, builder.create(), 2);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("car_kiln", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.CAR_KILN.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "car_kiln"));
        man.addEntry(CATEGORY, builder.create(), 3);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("rotary_kiln", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.ROTARY_KILN.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "rotary_kiln"));
        man.addEntry(CATEGORY, builder.create(), 4);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("steam_turbine", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.STEAMTURBINE.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "steam_turbine"));
        man.addEntry(CATEGORY, builder.create(), 5);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("chemical_reactor", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.Multiblock.CHEMICAL.get())));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "chemical_reactor"));
        man.addEntry(CATEGORY, builder.create(), 6);
        extras.put("steamTurbineGenerator", () -> IIConfig.SERVER.steamTurbineGenerator.get());
        extras.put("SteamTurbineMaximumInput", () -> IIConfig.SERVER.steamTurbineInputMax.get());
        extras.put("SteamTurbineMinimumInput", () -> IIConfig.SERVER.steamTurbineInputMin.get());
        extras.put("electrodeCost", () -> IIConfig.SERVER.electrodeCost.get());
        ((Consumer)ManualHelper.ADD_CONFIG_GETTER.getValue()).accept(s -> {
            String path;
            if (s.startsWith("immersiveindustry") && extras.containsKey(path = s.substring(s.indexOf(".") + 1))) {
                return extras.get(path).get();
            }
            return null;
        });
    }

    static {
        extras = new HashMap<String, Supplier<Object>>();
    }
}

