/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class StringListChooserScreen
extends CellScreen {
    protected Consumer<String> callback;
    protected List<String> list;

    public StringListChooserScreen(@NotNull Component title, @NotNull List<String> stringList, @NotNull Consumer<String> callback) {
        super(title);
        this.list = stringList;
        this.callback = callback;
    }

    @Override
    protected void initCells() {
        for (String s : this.list) {
            this.addCell(new StringCell(s)).setSelectable(true);
        }
        this.addSpacerCell(20);
    }

    @Override
    public boolean allowDone() {
        return this.getSelectedCell() != null;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        CellScreen.RenderCell cell = this.getSelectedCell();
        if (cell instanceof StringCell) {
            StringCell s = (StringCell)cell;
            this.callback.accept(s.string);
        }
    }

    public class StringCell
    extends CellScreen.LabelCell {
        public String string;

        public StringCell(String string) {
            super((Component)Component.m_237113_((String)string));
            this.string = string;
        }
    }
}

