/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.internal;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingRequirementGroup
implements ValuePlaceholderHolder {
    public LoadingRequirementContainer parent;
    public String identifier;
    public GroupMode mode;
    protected final Map<String, Supplier<String>> valuePlaceholders = new HashMap<String, Supplier<String>>();
    protected final List<LoadingRequirementInstance> instances = new ArrayList<LoadingRequirementInstance>();

    public LoadingRequirementGroup(@NotNull String identifier, @NotNull GroupMode mode, @NotNull LoadingRequirementContainer parent) {
        this.parent = parent;
        this.identifier = identifier;
        this.mode = mode;
    }

    public boolean requirementsMet() {
        for (LoadingRequirementInstance i : this.instances) {
            boolean met = i.requirementMet();
            if (met && this.mode == GroupMode.OR) {
                return true;
            }
            if (met || this.mode != GroupMode.AND) continue;
            return false;
        }
        return this.mode != GroupMode.OR;
    }

    public void addInstance(LoadingRequirementInstance instance) {
        if (!this.instances.contains(instance)) {
            this.instances.add(instance);
            this.valuePlaceholders.forEach(instance::addValuePlaceholder);
        }
        instance.group = this;
    }

    @Nullable
    public LoadingRequirementInstance removeInstance(LoadingRequirementInstance instance) {
        instance.group = null;
        return this.instances.remove(instance) ? instance : null;
    }

    public List<LoadingRequirementInstance> getInstances() {
        return new ArrayList<LoadingRequirementInstance>(this.instances);
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        if (!CharacterFilter.buildResourceNameFilter().isAllowedText(placeholder)) {
            throw new RuntimeException("Illegal characters used in placeholder name! Use only [a-z], [0-9], [_], [-]!");
        }
        this.valuePlaceholders.put(placeholder, replaceWithSupplier);
        for (LoadingRequirementInstance i : this.instances) {
            i.addValuePlaceholder(placeholder, replaceWithSupplier);
        }
    }

    @Override
    @NotNull
    public Map<String, Supplier<String>> getValuePlaceholders() {
        return this.valuePlaceholders;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof LoadingRequirementGroup) {
            LoadingRequirementGroup other = (LoadingRequirementGroup)o;
            if (!Objects.equals(this.identifier, other.identifier)) {
                return false;
            }
            if (this.mode != other.mode) {
                return false;
            }
            return ListUtils.contentEqualIgnoreOrder(this.instances, other.instances);
        }
        return false;
    }

    public LoadingRequirementGroup copy(boolean unique) {
        LoadingRequirementGroup g = new LoadingRequirementGroup(unique ? ScreenCustomization.generateUniqueIdentifier() : this.identifier, this.mode, null);
        this.instances.forEach(instance -> {
            LoadingRequirementInstance i = instance.copy(unique);
            i.group = g;
            g.instances.add(i);
        });
        g.valuePlaceholders.putAll(this.valuePlaceholders);
        return g;
    }

    @NotNull
    public static PropertyContainer serializeRequirementGroup(@NotNull LoadingRequirementGroup group) {
        PropertyContainer sec = new PropertyContainer("requirement_group");
        String key = "[loading_requirement_group:" + group.identifier + "]";
        String value = "[group_mode:" + group.mode.name + "]";
        sec.putProperty(key, value);
        for (LoadingRequirementInstance i : group.instances) {
            i.group = group;
            List<String> l = LoadingRequirementInstance.serializeRequirementInstance(i);
            sec.putProperty(l.get(0), l.get(1));
        }
        return sec;
    }

    @Nullable
    public static LoadingRequirementGroup deserializeRequirementGroup(@NotNull String key, @NotNull String value, @NotNull LoadingRequirementContainer parent) {
        if (key.startsWith("[loading_requirement_group:")) {
            String modeString;
            GroupMode mode;
            String groupId = key.split("\\[loading_requirement_group:", 2)[1].split("\\]", 2)[0];
            if (value.startsWith("[group_mode:") && (mode = GroupMode.getByName(modeString = value.split("\\[group_mode:", 2)[1].split("\\]", 2)[0])) != null) {
                return new LoadingRequirementGroup(groupId, mode, parent);
            }
        }
        return null;
    }

    public static enum GroupMode {
        AND("and"),
        OR("or");

        public final String name;

        private GroupMode(String name) {
            this.name = name;
        }

        @Nullable
        public static GroupMode getByName(String name) {
            for (GroupMode m : GroupMode.values()) {
                if (!m.name.equals(name)) continue;
                return m;
            }
            return null;
        }
    }
}

