/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef;

import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef.MCEFVideoMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef.MCEFVideoMenuBackgroundConfigScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoMenuBackgroundBuilder
extends MenuBackgroundBuilder<MCEFVideoMenuBackground> {
    public MCEFVideoMenuBackgroundBuilder() {
        super("video_mcef");
    }

    @Override
    public void buildNewOrEditInstance(Screen currentScreen, @Nullable MCEFVideoMenuBackground backgroundToEdit, @NotNull Consumer<MCEFVideoMenuBackground> backgroundConsumer) {
        MCEFVideoMenuBackground back;
        MCEFVideoMenuBackground mCEFVideoMenuBackground = back = backgroundToEdit != null ? (MCEFVideoMenuBackground)backgroundToEdit.copy() : null;
        if (back == null) {
            back = new MCEFVideoMenuBackground(this);
        }
        MCEFVideoMenuBackgroundConfigScreen s = new MCEFVideoMenuBackgroundConfigScreen(back, background -> {
            if (background != null) {
                backgroundConsumer.accept((MCEFVideoMenuBackground)background);
            } else {
                backgroundConsumer.accept(backgroundToEdit);
            }
            Minecraft.m_91087_().m_91152_(currentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    @Override
    public MCEFVideoMenuBackground deserializeBackground(SerializedMenuBackground serialized) {
        MCEFVideoMenuBackground background = new MCEFVideoMenuBackground(this);
        String source = serialized.getValue("source");
        background.rawVideoUrlSource = source != null ? ResourceSource.of(source) : null;
        background.loop = SerializationUtils.deserializeBoolean(background.loop, serialized.getValue("loop"));
        background.volume = SerializationUtils.deserializeNumber(Float.class, Float.valueOf(background.volume), serialized.getValue("volume")).floatValue();
        String soundSource = serialized.getValue("sound_source");
        if (soundSource != null) {
            background.soundSource = Objects.requireNonNullElse(MCEFVideoMenuBackgroundBuilder.getSoundSourceByName(soundSource), SoundSource.MASTER);
        }
        background.parallaxEnabled = SerializationUtils.deserializeBoolean(background.parallaxEnabled, serialized.getValue("parallax"));
        background.parallaxIntensityString = Objects.requireNonNullElse(serialized.getValue("parallax_intensity"), "0.02");
        background.invertParallax = SerializationUtils.deserializeBoolean(background.invertParallax, serialized.getValue("invert_parallax"));
        return background;
    }

    @Override
    public SerializedMenuBackground serializedBackground(MCEFVideoMenuBackground background) {
        SerializedMenuBackground serialized = new SerializedMenuBackground();
        if (background.rawVideoUrlSource != null) {
            serialized.putProperty("source", background.rawVideoUrlSource.getSerializationSource());
        }
        serialized.putProperty("loop", "" + background.loop);
        serialized.putProperty("volume", "" + background.volume);
        serialized.putProperty("sound_source", background.soundSource.m_12676_());
        serialized.putProperty("parallax", "" + background.parallaxEnabled);
        serialized.putProperty("parallax_intensity", background.parallaxIntensityString);
        serialized.putProperty("invert_parallax", "" + background.invertParallax);
        return serialized;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.backgrounds.video_mcef");
    }

    @Override
    @Nullable
    public Component[] getDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.video_mcef.desc", new String[0]);
    }

    @Nullable
    protected static SoundSource getSoundSourceByName(@NotNull String name) {
        for (SoundSource source : SoundSource.values()) {
            if (!source.m_12676_().equals(name)) continue;
            return source;
        }
        return null;
    }
}

