/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedVerticalHalfSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedVerticalHalfSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (!this.ySlope && quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && quadDir == this.dir.m_122427_()) {
            QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            boolean needOffset = this.top == (quadDir == Direction.DOWN);
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 1.0f, 0.0f)).applyIf(Modifiers.setPosition(0.5f), needOffset).export(quadMap.get(needOffset ? null : quadDir));
        } else if (quadDir == this.dir || quadDir == this.dir.m_122428_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }
}

