/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.ghost;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.client.data.ghost.DoubleBlockGhostRenderBehaviour;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.doubled.FramedAdjustableDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;

public final class AdjustableDoubleBlockGhostRenderBehaviour
extends DoubleBlockGhostRenderBehaviour {
    private final ModelProperty<Integer> offsetProperty;
    private final FramedAdjustableDoubleBlockEntity.OffsetPacker offsetPacker;

    private AdjustableDoubleBlockGhostRenderBehaviour(ModelProperty<Integer> offsetProperty, FramedAdjustableDoubleBlockEntity.OffsetPacker offsetPacker) {
        this.offsetProperty = offsetProperty;
        this.offsetPacker = offsetPacker;
    }

    @Override
    public ModelData appendModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, boolean secondPass, ModelData data) {
        int offsetsLeft = this.offsetPacker.pack(renderState, 8, false);
        int offsetsRight = this.offsetPacker.pack(renderState, 8, true);
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY).derive().with(this.offsetProperty, (Object)offsetsLeft).build();
        ModelData dataRight = Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_RIGHT), ModelData.EMPTY).derive().with(this.offsetProperty, (Object)offsetsRight).build();
        return data.derive().with(FramedDoubleBlockEntity.DATA_LEFT, (Object)dataLeft).with(FramedDoubleBlockEntity.DATA_RIGHT, (Object)dataRight).build();
    }

    public static AdjustableDoubleBlockGhostRenderBehaviour standard() {
        return new AdjustableDoubleBlockGhostRenderBehaviour(FramedCollapsibleBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsStandard);
    }

    public static AdjustableDoubleBlockGhostRenderBehaviour copycat() {
        return new AdjustableDoubleBlockGhostRenderBehaviour(FramedCollapsibleCopycatBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsCopycat);
    }
}

