/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class KittySlippersItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"fall").stat(StatData.builder((String)"modifier").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).ability(AbilityData.builder((String)"resurrected").requiredLevel(5).stat(StatData.builder((String)"chance").initialValue(0.05, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1184275).borderBottom(-9868951).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).build()).loot(LootData.builder().entry(LootCollections.JUNGLE).entry(LootCollections.VILLAGE).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        float yaw;
        Path path;
        PathNavigation navigation;
        Vec3 escapePosition;
        Vec3 escapeDirection;
        Player player;
        if (!(entity instanceof Player) || (player = (Player)entity).m_20193_().m_5776_()) {
            return;
        }
        Level level = player.m_20193_();
        for (Creeper creeper : level.m_45976_(Creeper.class, player.m_20191_().m_82400_(5.0))) {
            Vec3 creeperPosition = creeper.m_20182_();
            escapeDirection = player.m_20182_().m_82546_(creeperPosition).m_82541_().m_82490_(-1.0);
            escapePosition = creeperPosition.m_82549_(escapeDirection.m_82490_(5.0));
            navigation = creeper.m_21573_();
            path = navigation.m_26524_(escapePosition.f_82479_, escapePosition.f_82480_, escapePosition.f_82481_, 0);
            if (path != null) {
                navigation.m_26536_(path, 1.5);
            }
            creeper.m_6710_(null);
            creeper.f_20883_ = yaw = (float)Math.toDegrees(Math.atan2(escapeDirection.f_82481_, escapeDirection.f_82479_));
            creeper.f_20885_ = yaw;
        }
        for (Phantom phantom : level.m_45976_(Phantom.class, player.m_20191_().m_82400_(5.0))) {
            Vec3 phantomPosition = phantom.m_20182_();
            escapeDirection = player.m_20182_().m_82546_(phantomPosition).m_82541_().m_82490_(-1.0);
            escapePosition = phantomPosition.m_82549_(escapeDirection.m_82490_(5.0));
            navigation = phantom.m_21573_();
            path = navigation.m_26524_(escapePosition.f_82479_, escapePosition.f_82480_, escapePosition.f_82481_, 0);
            if (path != null) {
                navigation.m_26536_(path, 1.5);
            }
            phantom.m_6710_(null);
            phantom.f_20883_ = yaw = (float)Math.toDegrees(Math.atan2(escapeDirection.f_82481_, escapeDirection.f_82479_));
            phantom.f_20885_ = yaw;
        }
    }

    @Mod.EventBusSubscriber
    public static class KittySlippersEvent {
        @SubscribeEvent
        public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
            LivingEntity livingEntity;
            if ((event.getEntity() instanceof Creeper || event.getEntity() instanceof Phantom) && (livingEntity = event.getNewTarget()) instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack itemStack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.get()));
                if (!(itemStack.m_41720_() instanceof KittySlippersItem)) {
                    return;
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.get()));
            if (!(stack.m_41720_() instanceof KittySlippersItem)) {
                return;
            }
            NBTUtils.setInt((ItemStack)stack, (String)"count", (int)((int)event.getAmount()));
        }

        @SubscribeEvent
        public static void onPlayerFall(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof KittySlippersItem)) {
                return;
            }
            KittySlippersItem relic = (KittySlippersItem)item;
            float distance = event.getDistance();
            float modifier = (float)relic.getAbilityValue(stack, "fall", "modifier");
            if (distance <= modifier) {
                event.setDistance(0.0f);
            } else {
                event.setDistance(distance - modifier);
            }
            if (distance > 4.0f) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            KittySlippersItem relic;
            RandomSource random;
            Level level;
            ItemStack stack;
            Player player;
            block6: {
                block5: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) {
                        return;
                    }
                    player = (Player)livingEntity;
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.get()));
                    level = player.m_20193_();
                    random = player.m_217043_();
                    Item item = stack.m_41720_();
                    if (!(item instanceof KittySlippersItem)) break block5;
                    relic = (KittySlippersItem)item;
                    if (!level.m_5776_() && relic.canPlayerUseActiveAbility(player, stack, "resurrected") && !((double)random.m_188501_() > relic.getAbilityValue(stack, "resurrected", "chance"))) break block6;
                }
                return;
            }
            NetworkHandler.sendToClient((Object)new PacketItemActivation(stack), (ServerPlayer)((ServerPlayer)player));
            level.m_6269_(null, (Entity)player, SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 0.9f + random.m_188501_() * 0.2f);
            relic.spreadExperience((LivingEntity)player, stack, NBTUtils.getInt((ItemStack)stack, (String)"count", (int)1));
            player.m_21153_(1.0f);
            event.setCanceled(true);
            NBTUtils.setBoolean((ItemStack)stack, (String)"toggled", (boolean)false);
            for (int i = 0; i < 50; ++i) {
                ((ServerLevel)level).m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.m_188503_(156), random.m_188503_(100 + random.m_188503_(156)), random.m_188503_(100 + random.m_188503_(156))), (float)0.5f, (int)60, (float)0.95f), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 1, (random.m_188500_() - 0.5) * 3.0, random.m_188500_() * 1.5, (random.m_188500_() - 0.5) * 3.0, 0.05);
            }
        }
    }
}

