/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.jei;

import appeng.core.AppEng;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.jei.JEIPlugin;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;

public class ReactionChamberCategory
implements IRecipeCategory<ReactionChamberRecipe> {
    public static final RecipeType<ReactionChamberRecipe> RECIPE_TYPE = RecipeType.create((String)"advanced_ae", (String)"reaction_chamber", ReactionChamberRecipe.class);
    private static final ResourceLocation BACKGROUND = AppEng.makeId((String)"textures/guis/reaction_chamber.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawableAnimated progress;
    private final IDrawableStatic bolt;

    public ReactionChamberCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createDrawable(BACKGROUND, 5, 15, 168, 75);
        this.icon = guiHelper.createDrawableItemStack(AAEBlocks.REACTION_CHAMBER.stack());
        IDrawableStatic progressDrawable = guiHelper.createDrawable(BACKGROUND, 176, 0, 6, 18);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.bolt = guiHelper.drawableBuilder(JEIPlugin.TEXTURE, 0, 0, 10, 12).setTextureSize(32, 32).build();
    }

    public RecipeType<ReactionChamberRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public Component getTitle() {
        return AAEText.EmiReactionChamber.text();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReactionChamberRecipe recipe, IFocusGroup focuses) {
        int index = 0;
        List<IngredientStack.Item> inputs = recipe.getInputs();
        for (IngredientStack.Item in : inputs) {
            int x = 37 + index % 3 * 18;
            int y = 9 + index / 3 * 18;
            if (!in.isEmpty()) {
                builder.addInputSlot(x, y).addIngredients(Ingredient.m_43921_(Arrays.stream(((Ingredient)in.getIngredient()).m_43908_()).map(oldStack -> oldStack.m_255036_(in.getAmount()))));
            }
            ++index;
        }
        if (recipe.getFluid() != null) {
            IngredientStack.Fluid fluid = recipe.getFluid();
            IRecipeSlotBuilder slot = builder.addInputSlot(4, 6).setFluidRenderer(16000L, false, 16, 58);
            slot.addFluidStack((Fluid)fluid.getIngredient(), (long)fluid.getAmount());
        }
        if (recipe.isItemOutput()) {
            builder.addOutputSlot(113, 28).addItemStack(recipe.getResultItem());
        } else {
            IRecipeSlotBuilder slot = builder.addOutputSlot(146, 6).setFluidRenderer(16000L, false, 16, 58);
            slot.addFluidStack(recipe.getResultFluid().getFluid(), (long)recipe.getResultFluid().getAmount());
        }
    }

    public void draw(ReactionChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.progress.draw(guiGraphics, 135, 27);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent text = AAEText.ReactionChamberEnergy.text(new Object[]{recipe.getEnergy() / 1000});
        FormattedCharSequence formattedcharsequence = text.m_7532_();
        int textX = this.getWidth() / 2 + 4 - font.m_92724_(formattedcharsequence) / 2;
        guiGraphics.m_280614_(font, (Component)text, textX, 66, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
        this.bolt.draw(guiGraphics, textX - 12, 64);
    }
}

