/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.recipes.InitRecipeTypes;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipeSerializer;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberRecipe
implements Recipe<Container> {
    public static final ResourceLocation TYPE_ID = AdvancedAE.makeId("reaction");
    public static final RecipeType<ReactionChamberRecipe> TYPE = InitRecipeTypes.register(TYPE_ID.toString());
    public ResourceLocation id;
    public final List<IngredientStack.Item> inputs;
    public final IngredientStack.Fluid fluid;
    public final GenericStack output;
    protected final int energy;

    public ReactionChamberRecipe(ResourceLocation id, GenericStack output, List<IngredientStack.Item> inputs, IngredientStack.Fluid fluid, int energy) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.fluid = fluid;
        this.energy = energy;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public boolean isItemOutput() {
        return this.output.what() instanceof AEItemKey;
    }

    public ItemStack getResultItem() {
        AEKey aEKey = this.output.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey key = (AEItemKey)aEKey;
            return key.toStack((int)this.output.amount());
        }
        return ItemStack.f_41583_;
    }

    public FluidStack getResultFluid() {
        AEKey aEKey = this.output.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey key = (AEFluidKey)aEKey;
            return key.toStack((int)this.output.amount());
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return ReactionChamberRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public List<IngredientStack.Item> getInputs() {
        return this.inputs;
    }

    public List<IngredientStack<?, ?>> getValidInputs() {
        ArrayList validInputs = new ArrayList();
        for (IngredientStack.Item input : this.inputs) {
            if (input.isEmpty()) continue;
            validInputs.add((IngredientStack<?, ?>)input.sample());
        }
        validInputs.add((IngredientStack<?, ?>)this.fluid.sample());
        return validInputs;
    }

    @Nullable
    public IngredientStack.Fluid getFluid() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean containsIngredient(ItemStack stack) {
        for (IngredientStack.Item input : this.inputs) {
            if (input.isEmpty() || !input.test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIngredient(FluidStack stack) {
        return this.fluid.test(stack);
    }
}

