/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterTermScreen;
import net.pedroksl.ae2addonlib.network.AddonPacket;

public class QuantumCrafterTerminalPacket
extends AddonPacket {
    private final boolean fullUpdate;
    private final long inventoryId;
    private int inventorySize;
    private long sortBy;
    private final Int2ObjectMap<ItemStack> slots;
    private final Int2BooleanMap enabledArray;
    private final Int2BooleanMap invalidArray;

    public QuantumCrafterTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) {
        this.fullUpdate = fullUpdate;
        this.inventoryId = inventoryId;
        this.inventorySize = inventorySize;
        this.sortBy = sortBy;
        this.slots = slots;
        this.enabledArray = enabledArray;
        this.invalidArray = invalidArray;
    }

    public QuantumCrafterTerminalPacket(FriendlyByteBuf stream) {
        int key;
        int i;
        this.inventoryId = stream.m_130258_();
        this.fullUpdate = stream.readBoolean();
        this.inventorySize = 0;
        this.sortBy = 0L;
        if (this.fullUpdate) {
            this.inventorySize = stream.m_130242_();
            this.sortBy = stream.m_130258_();
        }
        int size = stream.readInt();
        this.slots = new Int2ObjectOpenHashMap(size);
        for (i = 0; i < size; ++i) {
            key = stream.readInt();
            ItemStack value = stream.m_130267_();
            this.slots.put(key, (Object)value);
        }
        size = stream.readInt();
        this.enabledArray = new Int2BooleanOpenHashMap(size);
        for (i = 0; i < size; ++i) {
            key = stream.readInt();
            boolean value = stream.readBoolean();
            this.enabledArray.put(key, value);
        }
        size = stream.readInt();
        this.invalidArray = new Int2BooleanOpenHashMap(size);
        for (i = 0; i < size; ++i) {
            key = stream.readInt();
            boolean value = stream.readBoolean();
            this.invalidArray.put(key, value);
        }
    }

    public void write(FriendlyByteBuf stream) {
        stream.m_130103_(this.inventoryId);
        stream.writeBoolean(this.fullUpdate);
        if (this.fullUpdate) {
            stream.m_130130_(this.inventorySize);
            stream.m_130103_(this.sortBy);
        }
        stream.writeInt(this.slots.size());
        for (Int2ObjectMap.Entry entry : this.slots.int2ObjectEntrySet()) {
            stream.writeInt(entry.getIntKey());
            stream.writeItemStack((ItemStack)entry.getValue(), false);
        }
        stream.writeInt(this.enabledArray.size());
        for (Int2ObjectMap.Entry entry : this.enabledArray.int2BooleanEntrySet()) {
            stream.writeInt(entry.getIntKey());
            stream.writeBoolean(entry.getBooleanValue());
        }
        stream.writeInt(this.invalidArray.size());
        for (Int2ObjectMap.Entry entry : this.invalidArray.int2BooleanEntrySet()) {
            stream.writeInt(entry.getIntKey());
            stream.writeBoolean(entry.getBooleanValue());
        }
    }

    public static QuantumCrafterTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, Int2ObjectMap<ItemStack> slots, Int2BooleanArrayMap enabledArray, Int2BooleanArrayMap invalidArray) {
        return new QuantumCrafterTerminalPacket(true, inventoryId, inventorySize, sortBy, slots, (Int2BooleanMap)enabledArray, (Int2BooleanMap)invalidArray);
    }

    public static QuantumCrafterTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots, Int2BooleanArrayMap enabledArray, Int2BooleanArrayMap invalidArray) {
        return new QuantumCrafterTerminalPacket(false, inventoryId, 0, 0L, slots, (Int2BooleanMap)enabledArray, (Int2BooleanMap)invalidArray);
    }

    public void clientPacketData(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof QuantumCrafterTermScreen) {
            QuantumCrafterTermScreen screen2 = (QuantumCrafterTermScreen)screen;
            if (this.fullUpdate) {
                screen2.postFullUpdate(this.inventoryId, this.sortBy, this.inventorySize, this.slots, this.enabledArray, this.invalidArray);
            } else {
                screen2.postIncrementalUpdate(this.inventoryId, this.slots, this.enabledArray, this.invalidArray);
            }
        }
    }
}

