/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.Tooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.pedroksl.advanced_ae.common.definitions.AAENbt;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.armors.IGridLinkedItem;
import net.pedroksl.advanced_ae.common.items.armors.PoweredItem;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import org.jetbrains.annotations.NotNull;

public interface IUpgradeableItem
extends IGridLinkedItem {
    public List<UpgradeType> getPossibleUpgrades();

    default public List<UpgradeType> getAppliedUpgrades(ItemStack stack) {
        ArrayList<UpgradeType> appliedUpgrades = new ArrayList<UpgradeType>();
        for (UpgradeType upgrade : this.getPossibleUpgrades()) {
            if (!this.hasUpgrade(stack, upgrade)) continue;
            appliedUpgrades.add(upgrade);
        }
        return appliedUpgrades;
    }

    default public List<UpgradeType> getPassiveUpgrades(ItemStack itemStack) {
        ArrayList<UpgradeType> abilityList = new ArrayList<UpgradeType>();
        this.getAppliedUpgrades(itemStack).forEach(up -> {
            if (up.applicationType == UpgradeType.ApplicationType.PASSIVE || up.applicationType == UpgradeType.ApplicationType.BUFF) {
                abilityList.add((UpgradeType)((Object)up));
            }
        });
        return abilityList;
    }

    default public boolean isUpgradeEnabled(@NotNull ItemStack stack, UpgradeType type) {
        CompoundTag tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type));
        if (tag != null) {
            return tag.m_128471_("enabled");
        }
        return false;
    }

    default public boolean isUpgradePowered(@NotNull ItemStack stack, UpgradeType upgrade) {
        LazyOptional energyOp = stack.getCapability(ForgeCapabilities.ENERGY);
        return energyOp.isPresent() && ((IEnergyStorage)energyOp.resolve().get()).getEnergyStored() >= upgrade.getCost();
    }

    default public boolean isUpgradeEnabledAndPowered(ItemStack stack, UpgradeType upgrade) {
        return this.isUpgradeEnabled(stack, upgrade) && this.isUpgradePowered(stack, upgrade);
    }

    default public boolean isUpgradeAllowed(UpgradeType type) {
        return this.getPossibleUpgrades().contains((Object)type);
    }

    default public boolean hasUpgrade(ItemStack stack, UpgradeType type) {
        return stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type)) != null;
    }

    default public boolean applyUpgrade(ItemStack stack, UpgradeType type) {
        if (!this.isUpgradeAllowed(type) || this.hasUpgrade(stack, type)) {
            return false;
        }
        this.getAppliedUpgrades(stack).add(type);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("enabled", true);
        tag.m_128405_("value", type.getSettings().defaultValue);
        tag.m_128365_("filter", (Tag)new ListTag());
        if (type.getExtraSettings() != UpgradeType.ExtraSettings.NONE) {
            tag.m_128379_("extra", true);
        }
        stack.m_41700_(AAENbt.UPGRADE_TAG.get((Object)type), (Tag)tag);
        return true;
    }

    default public boolean removeUpgrade(ItemStack stack, UpgradeType type) {
        if (this.getAppliedUpgrades(stack).contains((Object)type)) {
            stack.m_41749_(AAENbt.UPGRADE_TAG.get((Object)type));
            this.getAppliedUpgrades(stack).remove((Object)type);
            return true;
        }
        return false;
    }

    default public boolean toggleUpgrade(ItemStack stack, UpgradeType type) {
        return this.toggleUpgrade(stack, type, null);
    }

    default public boolean toggleUpgrade(ItemStack stack, UpgradeType type, Player player) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null) {
            tag.m_128379_("enabled", !tag.m_128471_("enabled"));
            stack.m_41700_(AAENbt.UPGRADE_TAG.get((Object)type), (Tag)tag);
            if (player != null) {
                MutableComponent id = Component.m_237115_((String)((QuantumUpgradeBaseItem)type.item().m_5456_()).m_5524_());
                MutableComponent msg = id.m_130948_(Tooltips.NORMAL_TOOLTIP_TEXT);
                if (tag.m_128471_("enabled")) {
                    msg.m_7220_((Component)Component.m_237113_((String)" ON").m_130948_(Tooltips.GREEN));
                } else {
                    msg.m_7220_((Component)Component.m_237113_((String)" OFF").m_130948_(Tooltips.RED));
                }
                player.m_5661_((Component)msg, true);
            }
            return true;
        }
        if (player != null) {
            MutableComponent id = Component.m_237115_((String)((QuantumUpgradeBaseItem)type.item().m_5456_()).m_5524_());
            player.m_5661_((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
        }
        return false;
    }

    default public int getUpgradeValue(@NotNull ItemStack stack, UpgradeType type, int defaultValue) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null && tag.m_128441_("value")) {
            return tag.m_128451_("value");
        }
        return defaultValue;
    }

    default public void setUpgradeValue(@NotNull ItemStack stack, UpgradeType type, int value) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null) {
            tag.m_128405_("value", value);
            stack.m_41700_(AAENbt.UPGRADE_TAG.get((Object)type), (Tag)tag);
        }
    }

    default public List<GenericStack> getFilter(@NotNull ItemStack stack, UpgradeType type) {
        CompoundTag tag;
        ArrayList<GenericStack> list = new ArrayList<GenericStack>();
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null && tag.m_128441_("filter")) {
            ListTag listTag = tag.m_128437_("filter", 10);
            for (Tag value : listTag) {
                list.add(GenericStack.readTag((CompoundTag)((CompoundTag)value)));
            }
        }
        return list;
    }

    default public void setFilter(@NotNull ItemStack stack, UpgradeType type, List<GenericStack> list) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null) {
            ListTag listTag = new ListTag();
            for (GenericStack genStack : list) {
                listTag.add((Object)GenericStack.writeTag((GenericStack)genStack));
            }
            tag.m_128365_("filter", (Tag)listTag);
            stack.m_41700_(AAENbt.UPGRADE_TAG.get((Object)type), (Tag)tag);
        }
    }

    default public boolean getUpgradeExtra(@NotNull ItemStack stack, UpgradeType type, boolean defaultValue) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null && tag.m_128441_("extra")) {
            return tag.m_128471_("extra");
        }
        return defaultValue;
    }

    default public void setUpgradeExtra(@NotNull ItemStack stack, UpgradeType type, boolean value) {
        CompoundTag tag;
        if (this.hasUpgrade(stack, type) && (tag = stack.m_41737_(AAENbt.UPGRADE_TAG.get((Object)type))) != null) {
            tag.m_128379_("extra", value);
            stack.m_41700_(AAENbt.UPGRADE_TAG.get((Object)type), (Tag)tag);
        }
    }

    default public void tickUpgrades(Level level, Player player, ItemStack stack) {
        for (UpgradeType upgrade : this.getAppliedUpgrades(stack)) {
            if (upgrade.applicationType == UpgradeType.ApplicationType.PASSIVE && this.isUpgradeEnabled(stack, upgrade) && upgrade.ability != null) {
                if (upgrade.ability.execute(level, player, stack)) {
                    this.consumeEnergy(player, stack, upgrade);
                }
            } else if (upgrade.applicationType == UpgradeType.ApplicationType.BUFF && this.isUpgradeEnabled(stack, upgrade)) {
                this.consumeEnergy(player, stack, upgrade);
            }
            if (upgrade != UpgradeType.FLIGHT || upgrade.ability == null) continue;
            upgrade.ability.execute(level, player, stack);
            if (!player.m_150110_().f_35935_) continue;
            this.consumeEnergy(player, stack, upgrade);
        }
    }

    default public void consumeEnergy(Player player, ItemStack stack, UpgradeType upgrade) {
        this.consumeEnergy(player, stack, upgrade.getCost());
    }

    default public void consumeEnergy(Player player, ItemStack stack, int amount) {
        if (player.m_7500_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof PoweredItem) {
            PoweredItem item2 = (PoweredItem)item;
            PowerMultiplier multi = PowerMultiplier.CONFIG;
            item2.extractAEPower(stack, multi.multiply((double)amount), Actionable.MODULATE);
        } else {
            LazyOptional energyOp = stack.getCapability(ForgeCapabilities.ENERGY);
            energyOp.ifPresent(e -> e.extractEnergy(amount, false));
        }
    }
}

