/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import appeng.util.BlockApiCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.pedroksl.advanced_ae.common.helpers.StorageReader;

public class StorageReaderImpl<T, S>
implements StorageReader {
    private final BlockApiCache<T> cache;
    private final BlockApiCache<MEStorage> meCache;
    private final HandlerStrategy<T, S> conversion;
    private final Direction fromSide;

    public StorageReaderImpl(Capability<T> capability, HandlerStrategy<T, S> conversion, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockApiCache.create(capability, (ServerLevel)level, (BlockPos)fromPos);
        this.meCache = BlockApiCache.create((Capability)Capabilities.STORAGE, (ServerLevel)level, (BlockPos)fromPos);
        this.conversion = conversion;
        this.fromSide = fromSide;
    }

    @Override
    public long getCurrentStock(AEKey what) {
        KeyCounter keys;
        if (what.getType() != this.conversion.getKeyType()) {
            return 0L;
        }
        MEStorage meHandler = (MEStorage)this.meCache.find(this.fromSide);
        if (meHandler != null && (keys = meHandler.getAvailableStacks()).get(what) > 0L) {
            return keys.get(what);
        }
        Object adjacentHandler = this.cache.find(this.fromSide);
        if (adjacentHandler == null) {
            return 0L;
        }
        ExternalStorageFacade adjacentStorage = this.conversion.getFacade(adjacentHandler);
        long amount = adjacentStorage.getAvailableStacks().get(what);
        return Math.max(0L, amount);
    }

    public static StorageReader item(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageReaderImpl(ForgeCapabilities.ITEM_HANDLER, HandlerStrategy.ITEMS, level, fromPos, fromSide);
    }

    public static StorageReader fluid(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageReaderImpl(ForgeCapabilities.FLUID_HANDLER, HandlerStrategy.FLUIDS, level, fromPos, fromSide);
    }
}

