/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.helpers.ToggleUpgradeCardAction;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.ae2addonlib.registry.HotkeyRegistry;

public final class AAEHotkeysRegistry
extends HotkeyRegistry {
    public static final AAEHotkeysRegistry INSTANCE = new AAEHotkeysRegistry();

    AAEHotkeysRegistry() {
        super("advanced_ae", id -> Keys.valueOf(id).getDefaultHotkey(), arg_0 -> ((AAEHotkeys)AAEHotkeys.INSTANCE).registerHotkey(arg_0));
    }

    public void init() {
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_HELMET, (player, slot, stack) -> ((QuantumHelmet)AAEItems.QUANTUM_HELMET.get()).openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_CHESTPLATE, (player, slot, stack) -> ((QuantumChestplate)AAEItems.QUANTUM_CHESTPLATE.get()).openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_LEGGINGS, (player, slot, stack) -> ((QuantumLeggings)AAEItems.QUANTUM_LEGGINGS.get()).openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_BOOTS, (player, slot, stack) -> ((QuantumBoots)AAEItems.QUANTUM_BOOTS.get()).openFromEquipmentSlot(player, slot, stack), Keys.ARMOR_CONFIG.id);
        this.register((ItemLike)AAEItems.ADV_PATTERN_ENCODER, (player, locator) -> ((AdvPatternEncoderItem)AAEItems.ADV_PATTERN_ENCODER.get()).openFromInventory(player, locator), Keys.PATTERN_ENCODER.id);
        this.registerToggleUpgradeAction((ItemLike)AAEItems.QUANTUM_HELMET, (player, stack) -> ((QuantumHelmet)AAEItems.QUANTUM_HELMET.get()).toggleUpgrade(stack, UpgradeType.MAGNET, player), Keys.QUANTUM_MAGNET_UPGRADE.id);
        this.registerToggleUpgradeAction((ItemLike)AAEItems.QUANTUM_HELMET, (player, stack) -> ((QuantumHelmet)AAEItems.QUANTUM_HELMET.get()).toggleUpgrade(stack, UpgradeType.AUTO_STOCK, player), Keys.QUANTUM_AUTO_STOCK_UPGRADE.id);
        this.registerToggleUpgradeAction((ItemLike)AAEItems.QUANTUM_HELMET, (player, stack) -> ((QuantumHelmet)AAEItems.QUANTUM_HELMET.get()).toggleUpgrade(stack, UpgradeType.NIGHT_VISION, player), Keys.QUANTUM_NIGHT_VISION_UPGRADE.id);
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_HELMET, (player, slot, stack) -> ((QuantumHelmet)AAEItems.QUANTUM_HELMET.get()).openPortableWorkbench(player, slot, stack), Keys.PORTABLE_WORKBENCH.id);
        this.registerArmorAction((ItemLike)AAEItems.QUANTUM_CHESTPLATE, (player, slot, stack) -> ((QuantumChestplate)AAEItems.QUANTUM_CHESTPLATE.get()).attemptCraftingTarget(player, slot, stack), Keys.PICK_CRAFT.id);
    }

    public void registerToggleUpgradeAction(ItemLike item, ToggleUpgradeCardAction.Opener opener, String id) {
        this.register(new ToggleUpgradeCardAction(item, opener), id);
    }

    public static enum Keys {
        ARMOR_CONFIG("quantum_armor_config", "Open Quantum Armor Configuration", 78),
        PATTERN_ENCODER("pattern_encoder_action", "Open Advanced Pattern Encoder"),
        QUANTUM_MAGNET_UPGRADE("quantum_magnet_upgrade", "Toggle Quantum Armor Magnet", 71),
        QUANTUM_AUTO_STOCK_UPGRADE("quantum_auto_stock_upgrade", "Toggle Quantum Armor Auto Stock", 74),
        QUANTUM_NIGHT_VISION_UPGRADE("quantum_night_vision_upgrade", "Toggle Quantum Armor Night Vision"),
        PORTABLE_WORKBENCH("portable_workbench", "Open Portable Workbench", 67),
        PICK_CRAFT("pick_craft", "Attempt crafting targeted block", 86);

        private final String id;
        private final String englishTranslation;
        private final int defaultHotkey;

        private Keys(String id, String englishTranslation) {
            this(id, englishTranslation, -1);
        }

        private Keys(String id, String englishTranslation, int defaultHotekey) {
            this.id = id;
            this.englishTranslation = englishTranslation;
            this.defaultHotkey = defaultHotekey;
        }

        public String getId() {
            return this.id;
        }

        public String getEnglishTranslation() {
            return this.englishTranslation;
        }

        public int getDefaultHotkey() {
            return this.defaultHotkey;
        }
    }
}

