/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.datafixer;

import com.lilypuree.connectiblechains.datafixer.NbtFixer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class ChainKnotFixer
extends NbtFixer {
    public static final ChainKnotFixer INSTANCE = new ChainKnotFixer();

    @Override
    protected int getVersion() {
        return 30100;
    }

    @Override
    public void registerFixers() {
        this.addFix(20100, "Make Chains position relative", this::fixChainPos201);
        this.addFix(30100, "Use new SourceItem instead of ChainType", this::fixSourceItemInsteadOfChainType);
    }

    private CompoundTag fixSourceItemInsteadOfChainType(CompoundTag nbt) {
        if (this.isNotChainKnot201(nbt)) {
            return nbt;
        }
        if (nbt.m_128441_("ChainType")) {
            nbt.m_128473_("ChainType");
        }
        nbt.m_128359_("SourceItem", "minecraft:chain");
        for (Tag linkElem : nbt.m_128437_("Chains", 10)) {
            if (!(linkElem instanceof CompoundTag)) continue;
            CompoundTag link = (CompoundTag)linkElem;
            if (link.m_128441_("ChainType")) {
                link.m_128473_("ChainType");
            }
            link.m_128359_("SourceItem", "minecraft:chain");
        }
        return nbt;
    }

    private CompoundTag fixChainPos201(CompoundTag nbt) {
        if (this.isNotChainKnot201(nbt)) {
            return nbt;
        }
        ListTag pos = nbt.m_128437_("Pos", 6);
        int sx = Mth.m_14107_((double)pos.m_128772_(0));
        int sy = Mth.m_14107_((double)pos.m_128772_(1));
        int sz = Mth.m_14107_((double)pos.m_128772_(2));
        for (Tag linkElem : nbt.m_128437_("Chains", 10)) {
            CompoundTag link;
            if (!(linkElem instanceof CompoundTag) || !(link = (CompoundTag)linkElem).m_128441_("X")) continue;
            int dx = link.m_128451_("X");
            int dy = link.m_128451_("Y");
            int dz = link.m_128451_("Z");
            link.m_128473_("X");
            link.m_128473_("Y");
            link.m_128473_("Z");
            link.m_128405_("RelX", dx - sx);
            link.m_128405_("RelY", dy - sy);
            link.m_128405_("RelZ", dz - sz);
        }
        return nbt;
    }

    private boolean isNotChainKnot201(CompoundTag nbt) {
        return !nbt.m_128461_("id").equals("connectiblechains:chain_knot");
    }
}

