/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.client.ClientInitializer;
import com.lilypuree.connectiblechains.client.render.entity.ChainRenderer;
import com.lilypuree.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ChainKnotEntityRenderer
extends EntityRenderer<ChainKnotEntity> {
    private final ChainKnotEntityModel<ChainKnotEntity> model;
    private final ChainRenderer chainRenderer = new ChainRenderer();

    public ChainKnotEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ChainKnotEntityModel(context.m_174023_(ClientInitializer.CHAIN_KNOT));
    }

    public ChainRenderer getChainRenderer() {
        return this.chainRenderer;
    }

    public boolean shouldRender(ChainKnotEntity entity, Frustum frustum, double x, double y, double z) {
        if (entity.f_19811_) {
            return true;
        }
        for (ChainLink link : entity.getLinks()) {
            if (link.primary != entity) continue;
            if (link.secondary instanceof Player) {
                return true;
            }
            if (!link.secondary.m_6000_(x, y, z)) continue;
            return true;
        }
        return super.m_5523_((Entity)entity, frustum, x, y, z);
    }

    public void render(ChainKnotEntity chainKnotEntity, float yaw, float partialTicks, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (chainKnotEntity.shouldRenderKnot()) {
            matrices.m_85836_();
            Vec3 leashOffset = chainKnotEntity.m_7398_(partialTicks).m_82546_(chainKnotEntity.m_20318_(partialTicks));
            matrices.m_85837_(leashOffset.f_82479_, leashOffset.f_82480_ + 0.40625, leashOffset.f_82481_);
            matrices.m_85841_(0.8333333f, 1.0f, 0.8333333f);
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(this.model.m_103119_(this.getKnotTexture(chainKnotEntity.getChainItemSource())));
            this.model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.m_85849_();
        }
        List<ChainLink> links = chainKnotEntity.getLinks();
        for (ChainLink link : links) {
            if (link.primary != chainKnotEntity || link.isDead()) continue;
            this.renderChainLink(link, partialTicks, matrices, vertexConsumers);
            if (!ConnectibleChains.runtimeConfig.doDebugDraw()) continue;
            this.drawDebugVector(matrices, (Entity)chainKnotEntity, link.secondary, vertexConsumers.m_6299_((RenderType)RenderType.f_110371_));
        }
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            matrices.m_85836_();
            MutableComponent holdingCount = Component.m_237113_((String)("F: " + chainKnotEntity.getLinks().stream().filter(l -> l.primary == chainKnotEntity).count()));
            MutableComponent heldCount = Component.m_237113_((String)("T: " + chainKnotEntity.getLinks().stream().filter(l -> l.secondary == chainKnotEntity).count()));
            matrices.m_85837_(0.0, 0.25, 0.0);
            this.m_7649_((Entity)chainKnotEntity, (Component)holdingCount, matrices, vertexConsumers, light);
            matrices.m_85837_(0.0, 0.25, 0.0);
            this.m_7649_((Entity)chainKnotEntity, (Component)heldCount, matrices, vertexConsumers, light);
            matrices.m_85849_();
        }
        super.m_7392_((Entity)chainKnotEntity, yaw, partialTicks, matrices, vertexConsumers, light);
    }

    private ResourceLocation getKnotTexture(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        BlockRenderDispatcher blockRender = Minecraft.m_91087_().m_91289_();
        BakedModel bakedModel = blockRender.m_110910_(block.m_49966_());
        return new ResourceLocation(id.m_135827_(), "textures/" + bakedModel.m_6160_().m_245424_().m_246162_().m_135815_() + ".png");
    }

    private ResourceLocation getChainTexture(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        BlockRenderDispatcher blockRender = Minecraft.m_91087_().m_91289_();
        BakedModel bakedModel = blockRender.m_110910_(block.m_49966_());
        return new ResourceLocation(id.m_135827_(), "textures/" + bakedModel.m_6160_().m_245424_().m_246162_().m_135815_() + ".png");
    }

    private void drawDebugVector(PoseStack matrices, Entity fromEntity, Entity toEntity, VertexConsumer buffer) {
        if (toEntity == null) {
            return;
        }
        Matrix4f modelMat = matrices.m_85850_().m_252922_();
        Vec3 vec = toEntity.m_20182_().m_82546_(fromEntity.m_20182_());
        Vec3 normal = vec.m_82541_();
        buffer.m_252986_(modelMat, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 0, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        buffer.m_252986_(modelMat, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(255, 0, 0, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private void renderChainLink(ChainLink link, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider) {
        ChainKnotEntity fromEntity = link.primary;
        Entity toEntity = link.secondary;
        matrices.m_85836_();
        Vec3 srcPos = fromEntity.m_20182_().m_82549_(fromEntity.m_7939_());
        Vec3 dstPos = toEntity instanceof HangingEntity ? toEntity.m_20182_().m_82549_(toEntity.m_245894_(0.0f)) : toEntity.m_7398_(tickDelta);
        Vec3 leashOffset = fromEntity.m_7939_();
        matrices.m_85837_(leashOffset.f_82479_, leashOffset.f_82480_, leashOffset.f_82481_);
        Item sourceItem = link.sourceItem;
        VertexConsumer buffer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)this.getChainTexture(Block.m_49814_((Item)sourceItem))));
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            buffer = vertexConsumerProvider.m_6299_(RenderType.m_110504_());
        }
        Vector3f offset = Helper.getChainOffset(srcPos, dstPos);
        matrices.m_252880_(offset.x(), 0.0f, offset.z());
        BlockPos blockPosOfStart = BlockPos.m_274446_((Position)fromEntity.m_20299_(tickDelta));
        BlockPos blockPosOfEnd = BlockPos.m_274446_((Position)toEntity.m_20299_(tickDelta));
        int blockLightLevelOfStart = fromEntity.m_9236_().m_45517_(LightLayer.BLOCK, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.m_9236_().m_45517_(LightLayer.BLOCK, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.m_9236_().m_45517_(LightLayer.SKY, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.m_9236_().m_45517_(LightLayer.SKY, blockPosOfEnd);
        Vec3 startPos = srcPos.m_82520_((double)offset.x(), 0.0, (double)offset.z());
        Vec3 endPos = dstPos.m_82520_((double)(-offset.x()), 0.0, (double)(-offset.z()));
        Vector3f chainVec = new Vector3f((float)(endPos.f_82479_ - startPos.f_82479_), (float)(endPos.f_82480_ - startPos.f_82480_), (float)(endPos.f_82481_ - startPos.f_82481_));
        float angleY = -((float)Math.atan2(chainVec.z(), chainVec.x()));
        matrices.m_252781_(new Quaternionf().rotateXYZ(0.0f, angleY, 0.0f));
        if (toEntity instanceof HangingEntity) {
            ChainRenderer.BakeKey key = new ChainRenderer.BakeKey(fromEntity.m_20182_(), toEntity.m_20182_());
            this.chainRenderer.renderBaked(buffer, matrices, key, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        } else {
            this.chainRenderer.render(buffer, matrices, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        }
        matrices.m_85849_();
    }

    public ResourceLocation getTextureLocation(ChainKnotEntity pEntity) {
        return this.getKnotTexture(pEntity.getChainItemSource());
    }
}

