/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.thermal;

import cofh.lib.common.block.CropBlockMushroom;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.minecraft.CropBlockAccessor;
import steve_gall.minecolonies_compatibility.module.common.thermal.ThermalModule;

public class MushroomFruit
extends CustomizedFruit {
    private final CropBlockMushroom block;

    public MushroomFruit(CropBlockMushroom block) {
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        ItemLike seed = ((CropBlockAccessor)this.block).invokeGetBaseSeedId();
        if (this.block.m_5456_() == Items.f_41852_ || this.block.m_5456_() == seed) {
            return Arrays.asList(new ItemStack(seed));
        }
        return Arrays.asList(new ItemStack(seed), new ItemStack((ItemLike)this.block));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.block));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == this.block;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return this.block.canHarvest(context.getState());
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return this.block.m_52307_(context.getState());
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        return ThermalModule.harvest(context, harvester);
    }
}

