/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_candlelight.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.candlelight.recipe.CookingPanRecipe;
import net.satisfy.candlelight.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.lets_do_candlelight.init.ModuleMenuTypes;

public class PanTeachMenu
extends TeachRecipeMenu<CookingPanRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 6;
    public static final int CRAFTING_COLS = 3;
    public static final int CRAFTING_X = 26;
    public static final int CRAFTING_Y = 17;
    public static final int RESULT_X = 120;
    public static final int RESULT_Y = 28;
    public static final int CONTAINER_X = 91;
    public static final int CONTAINER_Y = 55;

    public PanTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.PAN_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public PanTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.PAN_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 6);
        for (int i = 0; i < 6; ++i) {
            int col = i % 3;
            int row = i / 3;
            this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, i, 26 + col * 18, 17 + row * 18)));
        }
        this.resultContainer = new TeachContainer(this, 2);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 120, 28)));
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 1, 91, 55)));
    }

    @Override
    protected IMenuRecipeValidator<CookingPanRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CookingPanRecipe, Container>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<CookingPanRecipe> getRecipeType() {
                return (RecipeType)RecipeTypeRegistry.COOKING_PAN_RECIPE_TYPE.get();
            }

            @Override
            protected boolean test(CookingPanRecipe recipe, Container container, ServerPlayer player) {
                return this.matchesWithIngredientsCount(recipe, container);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull CookingPanRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        List<ItemStack> input = NBTUtils2.deserializeList(payload, "input", ItemStack::m_41712_);
        for (int i = 0; i < 6; ++i) {
            this.inputContainer.m_6836_(i, i < input.size() ? input.get(i) : ItemStack.f_41583_);
        }
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        this.resultContainer.m_6836_(0, this.recipe != null ? ((CookingPanRecipe)this.recipe).m_8043_(registryAccess) : ItemStack.f_41583_);
        this.resultContainer.m_6836_(1, this.recipe != null ? ((CookingPanRecipe)this.recipe).getContainer() : ItemStack.f_41583_);
    }
}

