/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_bakery.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.bakery.recipe.CraftingBowlRecipe;
import net.satisfy.bakery.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.lets_do_bakery.init.ModuleMenuTypes;

public class BowlTeachMenu
extends TeachRecipeMenu<CraftingBowlRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 4;
    public static final int CRAFTING_COLS = 2;
    public static final int CRAFTING_X = 35;
    public static final int CRAFTING_Y = 26;
    public static final int CRAFTING_COLUMNS = 3;
    public static final int CRAFTING_ROW = 2;
    public static final int RESULT_X = 130;
    public static final int RESULT_Y = 35;

    public BowlTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.BOWL_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public BowlTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.BOWL_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 4);
        for (int i = 0; i < 4; ++i) {
            int xi = i % 2;
            int yi = i / 2;
            this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, i, 35 + xi * 18, 26 + yi * 18)));
        }
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 130, 35)));
    }

    @Override
    protected IMenuRecipeValidator<CraftingBowlRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CraftingBowlRecipe, Container>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<CraftingBowlRecipe> getRecipeType() {
                return (RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get();
            }

            @Override
            protected boolean test(CraftingBowlRecipe recipe, Container container, ServerPlayer player) {
                return this.matchesWithIngredientsCount(recipe, container);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull CraftingBowlRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        List<ItemStack> input = NBTUtils2.deserializeList(payload, "input", ItemStack::m_41712_);
        for (int i = 0; i < 4; ++i) {
            this.inputContainer.m_6836_(i, i < input.size() ? input.get(i) : ItemStack.f_41583_);
        }
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        this.resultContainer.m_6836_(0, this.recipe != null ? ((CraftingBowlRecipe)this.recipe).m_8043_(registryAccess) : ItemStack.f_41583_);
    }
}

