/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ie;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.util.PersistentDataHelper;

public class DefaultBullet
implements BulletHandler.IBullet {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("ie_default");
    public static final DefaultBullet INSTANCE = new DefaultBullet();
    public static final String TAG_KEY = MineColoniesCompatibility.rl("bullet/ie_default").toString();
    private final ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_casull")};

    private DefaultBullet() {
    }

    public boolean isProperCartridge() {
        return false;
    }

    public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean charged) {
        CompoundTag payload = PersistentDataHelper.getOrEmpty(cartridge, TAG_KEY);
        projectile.getPersistentData().m_128365_(TAG_KEY, (Tag)payload);
        return projectile;
    }

    public static void putDamage(ItemStack cartridge, double damage) {
        PersistentDataHelper.getOrCreate(cartridge, TAG_KEY).m_128347_("Damage", damage);
    }

    public void onHitTarget(Level level, HitResult rtr, UUID shooterUUID, Entity projectile, boolean headshot) {
        if (level.m_5776_()) {
            return;
        }
        Entity hitEntity = null;
        if (rtr instanceof EntityHitResult) {
            EntityHitResult target = (EntityHitResult)rtr;
            hitEntity = target.m_82443_();
            if (hitEntity == null) {
                return;
            }
        } else {
            return;
        }
        Entity shooter = null;
        if (shooterUUID != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            shooter = serverLevel.m_8791_(shooterUUID);
        }
        double damage = PersistentDataHelper.getOrEmpty(projectile, TAG_KEY).m_128459_("Damage");
        if (headshot) {
            damage *= ((Double)MineColoniesCompatibilityConfigServer.INSTANCE.modules.IE.job.gunnerRevolver.defaultBulletHeadshotMultiplier.get()).doubleValue();
        }
        hitEntity.m_6469_(IEDamageSources.causeHomingDamage((RevolvershotEntity)((RevolvershotEntity)projectile), (Entity)shooter), (float)damage);
    }

    public ItemStack getCasing(ItemStack stack) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    public int getColour(ItemStack stack, int layer) {
        return -1;
    }
}

