/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.fruitsdelight;

import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.content.block.PassableLeavesBlock;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class TreeLeavesFruit
extends CustomizedFruit {
    private final BaseLeavesBlock leaves;
    private final ResourceLocation id;
    private final List<ItemStack> blockIcons;
    private final List<ItemStack> itemIcons;

    public TreeLeavesFruit(FDTrees tree) {
        this(tree.getLeaves(), tree.getSapling(), tree.getFruit());
    }

    public TreeLeavesFruit(BaseLeavesBlock leaves, SaplingBlock sapling, Item fruit) {
        this.leaves = leaves;
        this.id = ForgeRegistries.BLOCKS.getKey((Object)leaves);
        this.blockIcons = Arrays.asList(new ItemStack((ItemLike)leaves), new ItemStack((ItemLike)sapling));
        this.itemIcons = Arrays.asList(new ItemStack((ItemLike)fruit));
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return this.blockIcons;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_((Block)this.leaves);
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return context.getState().m_61143_((Property)PassableLeavesBlock.STATE) == PassableLeavesBlock.State.FRUITS;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState newState = (BlockState)context.getState().m_61124_((Property)PassableLeavesBlock.STATE, (Comparable)PassableLeavesBlock.State.LEAVES);
            level.m_7731_(context.getPosition(), newState, 3);
        }
        return context.getDrops(null);
    }
}

