/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.butcherable;

import com.lance5057.butchercraft.ButchercraftBlocks;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockBlock;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockBlockEntity;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.core.common.colony.ColonyHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.InventoryHelper;
import steve_gall.minecolonies_compatibility.core.common.util.InteractionMessageHelper;
import steve_gall.minecolonies_compatibility.mixin.common.butchercraft.ButcherBlockBlockEntityAccessor;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.butcherable.AbstractButcherable;

public class ButcherBlockButcherable
extends AbstractButcherable {
    private final ResourceLocation id;
    private final ButcherBlockRecipe recipe;
    private final List<ItemStack> itemIcons;
    private final List<BlockState> tableIcons;
    private final List<ToolOrIngredientStack> toolIcons;

    public ButcherBlockButcherable(ButcherBlockRecipe recipe) {
        this.id = recipe.m_6423_();
        this.recipe = recipe;
        this.itemIcons = Arrays.asList(recipe.getCarcassIn().m_43908_());
        this.tableIcons = Collections.singletonList(((ButcherBlockBlock)ButchercraftBlocks.BUTCHER_BLOCK.get()).m_49966_());
        this.toolIcons = this.getToolIcons((List<AnimatedRecipeItemUse>)recipe.getRecipeToolsIn());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    @NotNull
    public List<Ingredient> getOutputIcons() {
        return this.recipe.getDummyList();
    }

    @Override
    @NotNull
    public List<BlockState> getTableIcons() {
        return this.tableIcons;
    }

    @Override
    @NotNull
    public List<ToolOrIngredientStack> getToolsForIcon() {
        return this.toolIcons;
    }

    @Override
    public boolean testItem(@NotNull ItemStack item) {
        return this.recipe.getCarcassIn().test(item);
    }

    @Override
    public boolean isTableBlock(@NotNull ButcherBlockContext context) {
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getPosition());
        if (blockEntity instanceof ButcherBlockBlockEntity) {
            ButcherBlockBlockEntity blockEntity2 = (ButcherBlockBlockEntity)blockEntity;
            return blockEntity2.getInsertedItem().m_41619_();
        }
        return false;
    }

    @Override
    public void doButcherTable(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen, @NotNull InteractionHand itemHand) {
        super.doButcherTable(context, citizen, itemHand);
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getPosition());
        if (blockEntity instanceof ButcherBlockBlockEntity) {
            ButcherBlockBlockEntity blockEntity2 = (ButcherBlockBlockEntity)blockEntity;
            blockEntity2.insertItem(citizen.getWorker().m_21120_(itemHand));
        }
    }

    @Override
    @NotNull
    public ToolOrIngredientStack getBlockTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getPosition());
        if (blockEntity instanceof ButcherBlockBlockEntity) {
            ButcherBlockBlockEntity blockEntity2 = (ButcherBlockBlockEntity)blockEntity;
            ToolOrIngredientStack tool = blockEntity2.getCurrentTool().map(this::getTool).orElse(ToolOrIngredientStack.EMPTY);
            return this.trySkip(tool::testType, citizen.getAI()) ? ToolOrIngredientStack.EMPTY : tool;
        }
        return ToolOrIngredientStack.EMPTY;
    }

    @Override
    public boolean isButcheringBlock(@NotNull ButcherBlockContext context) {
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getPosition());
        if (blockEntity instanceof ButcherBlockBlockEntity) {
            ButcherBlockBlockEntity blockEntity2 = (ButcherBlockBlockEntity)blockEntity;
            return this.recipe.getCarcassIn().test(blockEntity2.getInsertedItem());
        }
        return false;
    }

    @Override
    public void doButcherBlock(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        super.doButcherBlock(context, citizen);
        BlockEntity blockEntity = context.getLevel().m_7702_(context.getPosition());
        if (blockEntity instanceof ButcherBlockBlockEntity) {
            ButcherBlockBlockEntity blockEntity2 = (ButcherBlockBlockEntity)blockEntity;
            FakePlayer player = ColonyHelper.getFakeOwner(citizen.getWorker().getCitizenData().getColony());
            if (player == null) {
                return;
            }
            if (blockEntity2.maxProgress == 0) {
                ((ButcherBlockBlockEntityAccessor)blockEntity2).invokeSetupStage(this.recipe, 0);
            }
            int stage = blockEntity2.stage;
            AnimatedRecipeItemUse itemUse = (AnimatedRecipeItemUse)this.recipe.getRecipeToolsIn().get(stage);
            if (this.trySkip(arg_0 -> ((Ingredient)itemUse.tool).test(arg_0), citizen.getAI())) {
                if (stage + 1 < this.recipe.getRecipeToolsIn().size()) {
                    ((ButcherBlockBlockEntityAccessor)blockEntity2).invokeSetupStage(this.recipe, stage + 1);
                } else {
                    blockEntity2.finishRecipe();
                }
                blockEntity2.updateInventory();
                return;
            }
            int maxProgress = blockEntity2.maxProgress;
            int maxToolCount = blockEntity2.toolCount * maxProgress;
            InteractionHand toolHand = InteractionHand.MAIN_HAND;
            ItemStack tool = citizen.getWorker().m_21120_(toolHand).m_41777_();
            tool.m_41764_(maxToolCount);
            blockEntity2.progress = maxProgress;
            blockEntity2.butcher((Player)player, tool);
            if (tool.m_41763_()) {
                CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)citizen.getWorker(), (InteractionHand)toolHand, (int)maxProgress);
            } else {
                InventoryCitizen inventory = citizen.getWorker().getInventoryCitizen();
                ToolOrIngredientStack toolType = this.getTool(itemUse);
                InventoryHelper.removeStacksFromItemHandler((IItemHandler)inventory, maxToolCount, toolType::testType);
            }
        }
    }

    @Override
    @NotNull
    public Component getTableNotFoundMessage() {
        return InteractionMessageHelper.getWorkingBlockNotFound((Block)ButchercraftBlocks.BUTCHER_BLOCK.get());
    }

    @NotNull
    public ButcherBlockRecipe getRecipe() {
        return this.recipe;
    }
}

