/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.atmospheric;

import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class PassionFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AtmosphericItems.PASSION_FRUIT.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericItems.PASSION_FRUIT.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == AtmosphericBlocks.PASSION_VINE.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)PassionVineBlock.AGE) == 4;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            int count = 1 + level.f_46441_.m_188503_(2) + level.f_46441_.m_188503_(2) + level.f_46441_.m_188503_(3);
            level.m_7731_(context.getPosition(), (BlockState)state.m_61124_((Property)PassionVineBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)AtmosphericItems.PASSION_FRUIT.get(), count));
        }
        return Collections.emptyList();
    }
}

