/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.jei;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.FruitIconCache;

public class OrchardistCategory
extends JobBasedRecipeCategory<FruitIconCache> {
    private final IDrawableStatic arrow;

    public OrchardistCategory(@NotNull IJob<?> job, @NotNull RecipeType<FruitIconCache> type, @NotNull IGuiHelper guiHelper) {
        super(job, type, new ItemStack((ItemLike)ModBlocks.blockHutLumberjack), guiHelper);
        this.arrow = guiHelper.createDrawable(TEXTURE, 20, 121, 24, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FruitIconCache recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = recipe.getBlockIcons();
        for (int i = 0; i < inputs.size(); ++i) {
            int x = 81;
            int y = 46 + (71 - this.arrow.getHeight()) / 2;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x + i * 18, y);
            slot.addItemStack(inputs.get(i));
        }
        List<ItemStack> outputs = recipe.getItemIcons();
        for (int i = 0; i < outputs.size(); ++i) {
            int x = 57 + i * 18;
            int y = 100;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.OUTPUT, x, y);
            slot.setBackground((IDrawable)this.slot, -1, -1);
            slot.addItemStack(outputs.get(i));
        }
        this.addToolSlot(builder, recipe.getFruit().getHarvestToolType(), 149, 26, true);
    }

    public void draw(FruitIconCache recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        this.arrow.draw(graphics, 53, 46 + (71 - this.arrow.getHeight()) / 2);
    }

    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull FruitIconCache recipe) {
        return Collections.emptyList();
    }
}

