/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTUtils2 {
    public static <T> List<T> deserializeList(@NotNull CompoundTag tag, @NotNull String key, Function<CompoundTag, T> elementFunc) {
        return NBTUtils2.deserializeList(tag, key, ArrayList::new, elementFunc);
    }

    public static <T, COLLECTION extends Collection<T>> COLLECTION deserializeList(@NotNull CompoundTag tag, @NotNull String key, IntFunction<COLLECTION> collectionFunc, Function<CompoundTag, T> elementFunc) {
        ListTag listTag = tag.m_128437_(key, 10);
        Collection collection = (Collection)collectionFunc.apply(listTag.size());
        for (int i = 0; i < listTag.size(); ++i) {
            collection.add(elementFunc.apply(listTag.m_128728_(i)));
        }
        return (COLLECTION)collection;
    }

    public static <T> ListTag serializeCollection(@NotNull CompoundTag tag, @NotNull String key, @NotNull Collection<T> list, @NotNull Function<T, CompoundTag> func) {
        ListTag listTag = new ListTag();
        tag.m_128365_(key, (Tag)listTag);
        for (T element : list) {
            listTag.add((Object)((Tag)func.apply(element)));
        }
        return listTag;
    }

    public static CompoundTag getOrEmpty(@Nullable CompoundTag tag, @NotNull String key) {
        if (tag != null && tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        return new CompoundTag();
    }

    public static CompoundTag getOrCreate(@Nullable CompoundTag tag, @NotNull String key) {
        if (tag != null) {
            if (tag.m_128425_(key, 10)) {
                return tag.m_128469_(key);
            }
            CompoundTag child = new CompoundTag();
            tag.m_128365_(key, (Tag)child);
            return child;
        }
        return new CompoundTag();
    }

    private NBTUtils2() {
    }
}

