/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.inventory.container.ContainerCrafting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.polymorph.PolymorphModule;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class TeachRecipeMenuSelectMessage
extends AbstractMessage {
    private final ResourceLocation recipeId;

    public TeachRecipeMenuSelectMessage(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public TeachRecipeMenuSelectMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.recipeId = buffer.m_130281_();
    }

    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130085_(this.recipeId);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        RegistryAccess registryAccess = player.m_9236_().m_9598_();
        Recipe recipe = player.m_9236_().m_7465_().m_44043_(this.recipeId).orElse(null);
        if (recipe == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerCrafting) {
            ContainerCrafting menu = (ContainerCrafting)abstractContainerMenu;
            menu.craftResult.m_6836_(0, ((CraftingRecipe)recipe).m_5874_((Container)menu.craftMatrix, registryAccess));
            if (ModuleManager.POLYMORPH.isLoaded()) {
                PolymorphModule.sendHighlightRecipe(player, this.recipeId);
            }
        } else {
            abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof TeachRecipeMenu) {
                TeachRecipeMenu menu = (TeachRecipeMenu)abstractContainerMenu;
                menu.setRecipeIndex(menu.getRecipes().indexOf(recipe));
            }
        }
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }
}

