/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import steve_gall.minecolonies_compatibility.api.common.building.module.IMenuBuildingModuleView;
import steve_gall.minecolonies_compatibility.core.common.network.message.BuildingModuleMessage;

public abstract class ModuleMenuOpenMessage
extends BuildingModuleMessage {
    protected final Component desc;

    public ModuleMenuOpenMessage(IBuildingModuleView module) {
        super(module);
        if (module instanceof IMenuBuildingModuleView) {
            IMenuBuildingModuleView menuBuilding = (IMenuBuildingModuleView)module;
            this.desc = menuBuilding.getMenuDesc();
        } else if (module instanceof CraftingModuleView) {
            CraftingModuleView craftingModule = (CraftingModuleView)module;
            String id = craftingModule.getId();
            this.desc = Component.m_237115_((String)("com.minecolonies.coremod.gui.workerhuts.recipe." + id + ".menu"));
        } else {
            this.desc = module.getDesc();
        }
    }

    public ModuleMenuOpenMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.desc = buffer.m_130238_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130083_(this.desc);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        final IBuildingModule module = this.getModule();
        if (module == null) {
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return ModuleMenuOpenMessage.this.getDisplayName();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return ModuleMenuOpenMessage.this.createMenu(windowId, inventory, player, module);
            }
        }, buffer -> this.toBuffer((FriendlyByteBuf)buffer, module));
    }

    protected Component getDisplayName() {
        return this.desc;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3, IBuildingModule var4);

    protected void toBuffer(FriendlyByteBuf buffer, IBuildingModule module) {
        this.getModulePos().serializeBuffer(buffer);
    }
}

