/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModule;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModuleView;
import steve_gall.minecolonies_compatibility.core.common.util.PersistentDataHelper;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModulePos;

public class RestrictToolItem
extends Item
implements IBlockOverlayItem {
    public static final String TAG_RESTRICT = "restrict";
    public static final String TAG_MODULE = "module";
    public static final String TAG_MODULE_NAME = "moduleName";
    public static final String TAG_POS_1 = "pos1";
    public static final String TAG_POS_2 = "pos2";

    public RestrictToolItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.m_5776_()) {
            ItemStack stack = player.m_21205_();
            this.setPos1(stack, pos);
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.set1", (Object[])new Object[0]).sendTo(new Player[]{player});
            this.updateModuleArea(player, stack);
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            Player player = context.m_43723_();
            ItemStack stack = context.m_43722_();
            this.setPos2(stack, context.m_8083_());
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.set2", (Object[])new Object[0]).sendTo(new Player[]{player});
            this.updateModuleArea(player, stack);
        }
        return InteractionResult.FAIL;
    }

    public void setModule(ItemStack stack, IRestrictableModule module, Component moduleDesc) {
        stack.m_41714_((Component)Component.m_237119_().m_7220_(super.m_7626_(stack)).m_130946_(": ").m_7220_(moduleDesc));
        stack.m_41749_(TAG_RESTRICT);
        CompoundTag tag = PersistentDataHelper.getOrCreate(stack, TAG_RESTRICT);
        tag.m_128365_(TAG_MODULE, (Tag)new ModulePos((IBuildingModule)module).serializeNBT());
        tag.m_128359_(TAG_MODULE_NAME, module.getBuilding().getBuildingDisplayName());
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ModulePos modulePos = this.getModulePos(stack);
        if (modulePos != null) {
            BlockPos pos = modulePos.getBuildingId();
            String name = PersistentDataHelper.getOrEmpty(stack, TAG_RESTRICT).m_128461_(TAG_MODULE_NAME);
            tooltip.add((Component)Component.m_237110_((String)"item.minecolonies_compatibility.restrict_tool.name", (Object[])new Object[]{Component.m_237115_((String)name)}));
            tooltip.add((Component)Component.m_237110_((String)"item.minecolonies_compatibility.restrict_tool.pos", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        }
    }

    @Nullable
    public ModulePos getModulePos(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(TAG_RESTRICT);
        return tag != null ? new ModulePos(tag.m_128469_(TAG_MODULE)) : null;
    }

    @Nullable
    public IRestrictableModule getModule(ItemStack stack) {
        IRestrictableModule module;
        IBuildingModule iBuildingModule;
        ModulePos pos = this.getModulePos(stack);
        return pos != null && (iBuildingModule = pos.getModule()) instanceof IRestrictableModule ? (module = (IRestrictableModule)iBuildingModule) : null;
    }

    @Nullable
    public IRestrictableModuleView getModuleView(ItemStack stack) {
        IRestrictableModuleView module;
        IBuildingModuleView iBuildingModuleView;
        ModulePos pos = this.getModulePos(stack);
        return pos != null && (iBuildingModuleView = pos.getModuleView()) instanceof IRestrictableModuleView ? (module = (IRestrictableModuleView)iBuildingModuleView) : null;
    }

    public void updateModuleArea(Player player, ItemStack stack) {
        int maxVolume;
        int distZ;
        int distY;
        BlockPos pos1 = this.getPos1(stack);
        BlockPos pos2 = this.getPos2(stack);
        if (pos1 == null || pos2 == null) {
            return;
        }
        IRestrictableModule module = this.getModule(stack);
        if (module == null) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)pos1, (Vec3i)pos2);
        int distX = box.m_162399_() - box.m_162395_() + 1;
        int volume = distX * (distY = box.m_162400_() - box.m_162396_() + 1) * (distZ = box.m_162401_() - box.m_162398_() + 1);
        if (volume > (maxVolume = (int)Math.floor(2.0 * Math.pow(module.getSearchRange(), 3.0)))) {
            MessageUtils.format((String)"minecolonies_compatibility.text.restrict.too_big", (Object[])new Object[]{volume, maxVolume}).sendTo(new Player[]{player});
            return;
        }
        MessageUtils.format((String)"minecolonies_compatibility.text.restrict.update", (Object[])new Object[]{box.m_162395_(), box.m_162399_(), box.m_162396_(), box.m_162400_(), box.m_162398_(), box.m_162401_(), volume, maxVolume}).sendTo(new Player[]{player});
        module.setRestrictArea(pos1, pos2);
    }

    protected void setPos(ItemStack stack, String key, @Nullable BlockPos pos) {
        if (pos == null) {
            PersistentDataHelper.getOrEmpty(stack, TAG_RESTRICT).m_128473_(key);
        } else {
            BlockPosUtil.write((CompoundTag)PersistentDataHelper.getOrCreate(stack, TAG_RESTRICT), (String)key, (BlockPos)pos);
        }
    }

    @Nullable
    protected BlockPos getPos(ItemStack stack, String key) {
        CompoundTag tag = PersistentDataHelper.getOrEmpty(stack, TAG_RESTRICT);
        return tag.m_128441_(key) ? BlockPosUtil.read((CompoundTag)tag, (String)key) : null;
    }

    public void setPos1(ItemStack stack, @Nullable BlockPos pos) {
        this.setPos(stack, TAG_POS_1, pos);
    }

    public void setPos2(ItemStack stack, @Nullable BlockPos pos) {
        this.setPos(stack, TAG_POS_2, pos);
    }

    @Nullable
    public BlockPos getPos1(ItemStack stack) {
        return this.getPos(stack, TAG_POS_1);
    }

    @Nullable
    public BlockPos getPos2(ItemStack stack) {
        return this.getPos(stack, TAG_POS_2);
    }

    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        IRestrictableModuleView module = this.getModuleView(stack);
        if (module != null) {
            BlockPos pos = module.getBuildingView().getID();
            BlockPos pos1 = module.getRestrictAreaPos1();
            BlockPos pos2 = module.getRestrictAreaPos2();
            BlockPos p1 = this.getPos1(stack);
            BlockPos p2 = this.getPos2(stack);
            ArrayList<IBlockOverlayItem.OverlayBox> boxes = new ArrayList<IBlockOverlayItem.OverlayBox>();
            if (p1 != null && p2 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p1).m_82367_(new AABB(p2)), -16711936, 0.04f, true));
            } else {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(pos1).m_82367_(new AABB(pos2)), -16711936, 0.04f, true));
            }
            if (p1 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p1), -65536, 0.02f, true));
            }
            if (p2 != null) {
                boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(p2), -16776961, 0.02f, true));
            }
            boxes.add(new IBlockOverlayItem.OverlayBox(new AABB(pos), -1, 0.02f, true));
            return boxes;
        }
        return Collections.emptyList();
    }
}

