/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingCraftingType;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingRecipeAccessor;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;

public class SmithingTeachMenu
extends TeachRecipeMenu<SmithingRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int TEMPLATE_X = 8;
    public static final int TEMPLATE_Y = 48;
    public static final int BASE_X = 26;
    public static final int BASE_Y = 48;
    public static final int ADDTION_X = 44;
    public static final int ADDTION_Y = 48;
    public static final int RESULT_X = 98;
    public static final int RESULT_Y = 48;
    private final int buildingLevel;

    public SmithingTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModMenuTypes.SMITHING_TEACH.get(), windowId, inventory, module);
        this.buildingLevel = module.getBuilding().getBuildingLevel();
        this.setup();
    }

    public SmithingTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModMenuTypes.SMITHING_TEACH.get(), windowId, inventory, buffer);
        this.buildingLevel = buffer.readInt();
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 3);
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 0, 8, 48)));
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 1, 26, 48)));
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 2, 44, 48)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 98, 48)));
    }

    @Override
    protected IMenuRecipeValidator<SmithingRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<SmithingRecipe, Container>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<SmithingRecipe> getRecipeType() {
                return RecipeType.f_44113_;
            }

            @Override
            protected boolean test(SmithingRecipe recipe, Container container, ServerPlayer player) {
                return recipe.m_5818_(container, this.level);
            }
        };
    }

    @Override
    @Nullable
    public Component getCurrentError() {
        ItemStack addition;
        ItemStack base;
        ItemStack template = this.inputContainer.m_8020_(0);
        Component error = this.getRecipeError(template, base = this.inputContainer.m_8020_(1), addition = this.inputContainer.m_8020_(2));
        if (error != null) {
            return error;
        }
        return super.getCurrentError();
    }

    @Nullable
    public Component getRecipeError(ItemStack template, ItemStack base, ItemStack addition) {
        return this.testRequiredLevel(SmithingCraftingType.getRequiredLevel(addition));
    }

    @Override
    public Component getRecipeError(SmithingRecipe recipe) {
        if (recipe instanceof SmithingRecipeAccessor) {
            SmithingRecipeAccessor accessor = (SmithingRecipeAccessor)recipe;
            Ingredient addition = accessor.getAddition();
            Component error = this.testRequiredLevel(SmithingCraftingType.getRequiredMinLevel(addition));
            if (error != null) {
                return error;
            }
            return super.getRecipeError(recipe);
        }
        return TEXT_RECIPE_NOT_SUPPORTED;
    }

    public Component testRequiredLevel(int requiredLevel) {
        if (this.buildingLevel < requiredLevel) {
            int maxLevel = 5;
            if (requiredLevel == maxLevel) {
                return Component.m_237110_((String)"com.minecolonies.coremod.jei.onelevelrestriction.tip", (Object[])new Object[]{requiredLevel});
            }
            return Component.m_237110_((String)"com.minecolonies.coremod.jei.levelrestriction.tip", (Object[])new Object[]{requiredLevel, maxLevel});
        }
        return null;
    }

    @Override
    protected void setContainerByTransfer(@NotNull SmithingRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        ListTag input = payload.m_128437_("input", 10);
        this.inputContainer.m_6836_(0, ItemStack.m_41712_((CompoundTag)input.m_128728_(0)));
        this.inputContainer.m_6836_(1, ItemStack.m_41712_((CompoundTag)input.m_128728_(1)));
        this.inputContainer.m_6836_(2, ItemStack.m_41712_((CompoundTag)input.m_128728_(2)));
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        if (this.recipe != null) {
            this.resultContainer.m_6836_(0, ((SmithingRecipe)this.recipe).m_5874_((Container)this.inputContainer, registryAccess));
        } else {
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        }
    }
}

