/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class SmithingRecipeStorage
implements ICustomizedRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("smithing");
    public static final String TAG_RECIPE_ID = "recipeId";
    public static final String TAG_TAMPLATE = "template";
    public static final String TAG_BASE = "base";
    public static final String TAG_ADDITION = "addition";
    public static final String TAG_RESULT = "result";
    private final ResourceLocation recipeId;
    private final ItemStorage template;
    private final ItemStorage base;
    private final ItemStorage addition;
    private final ItemStack result;
    private final List<ItemStorage> input;
    private final List<ItemStack> secondaryOutputs;

    public static void serialize(IFactoryController controller, CompoundTag tag, SmithingRecipeStorage recipe) {
        tag.m_128359_(TAG_RECIPE_ID, recipe.recipeId.toString());
        tag.m_128365_(TAG_TAMPLATE, (Tag)controller.serialize((Object)recipe.template));
        tag.m_128365_(TAG_BASE, (Tag)controller.serialize((Object)recipe.base));
        tag.m_128365_(TAG_ADDITION, (Tag)controller.serialize((Object)recipe.addition));
        tag.m_128365_(TAG_RESULT, (Tag)recipe.result.serializeNBT());
    }

    public static SmithingRecipeStorage deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_(TAG_RECIPE_ID));
        ItemStorage template = (ItemStorage)controller.deserialize(tag.m_128469_(TAG_TAMPLATE));
        ItemStorage base = (ItemStorage)controller.deserialize(tag.m_128469_(TAG_BASE));
        ItemStorage addition = (ItemStorage)controller.deserialize(tag.m_128469_(TAG_ADDITION));
        ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RESULT));
        return new SmithingRecipeStorage(recipeId, template, base, addition, result);
    }

    public SmithingRecipeStorage(ResourceLocation recipeId, ItemStorage template, ItemStorage base, ItemStorage addition, ItemStack result) {
        this.recipeId = recipeId;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.input = Arrays.asList(template, base, addition);
        this.secondaryOutputs = Arrays.asList(new ItemStack[0]);
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.template, this.base, this.addition, this.result.m_41720_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SmithingRecipeStorage) {
            SmithingRecipeStorage other = (SmithingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.template.equals((Object)other.template) && this.base.equals((Object)other.base) && this.addition.equals((Object)other.addition) && ItemStackHelper.equals(this.result, other.result);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public ItemStorage getBase() {
        return this.base;
    }

    public ItemStorage getAddition() {
        return this.addition;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    public int getGridSize() {
        return 2;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getAlternateOutputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    public Block getIntermediate() {
        return Blocks.f_50016_;
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceLocation getLootTable() {
        return null;
    }

    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

