/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeTags;

public class IngredientHelper {
    private static final Gson GSON = new Gson();

    public static List<List<ItemStack>> getStacksList(@NotNull List<Ingredient> ingredients) {
        return ingredients.stream().map(IngredientHelper::getStacks).toList();
    }

    public static List<ItemStack> getStacks(@NotNull Ingredient ingredient) {
        return Arrays.asList(ingredient.m_43908_());
    }

    public static boolean isTool(@NotNull Ingredient ingredient, @NotNull EquipmentTypeEntry toolType) {
        return Arrays.stream(ingredient.m_43908_()).filter(stack -> !ToolTypeTags.isInBlacklist((ItemStack)stack, (ResourceLocation)toolType.getRegistryName())).allMatch(stack -> ItemStackHelper.isTool(stack, toolType));
    }

    @NotNull
    public static EquipmentTypeEntry findFirstToolType(@NotNull Ingredient ingredient) {
        for (EquipmentTypeEntry toolType : IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry().getValues()) {
            if (toolType == ModEquipmentTypes.none.get() || !IngredientHelper.isTool(ingredient, toolType)) continue;
            return toolType;
        }
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @NotNull
    public static String toJson(@NotNull Ingredient ingredient) {
        return GSON.toJson(ingredient.m_43942_());
    }

    @NotNull
    public static Ingredient fromJson(@NotNull String json) {
        return Ingredient.m_43917_((JsonElement)((JsonElement)GSON.fromJson(json, JsonElement.class)));
    }

    public static boolean isDamageable(@NotNull Ingredient ingredient) {
        if (ingredient.m_43947_()) {
            return false;
        }
        for (ItemStack item : ingredient.m_43908_()) {
            if (item.m_41763_()) continue;
            return false;
        }
        return true;
    }

    private IngredientHelper() {
    }
}

