/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModuleView;
import steve_gall.minecolonies_compatibility.core.client.gui.RestrictableModuleWindow;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.network.message.RestrictSetAreaMessage;
import steve_gall.minecolonies_compatibility.core.common.network.message.RestrictSetEnabledMessage;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class RestrictableModuleView
extends AbstractBuildingModuleView
implements IRestrictableModuleView {
    public static final Component DESC = Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.restrict");
    private boolean restrictEnabled = false;
    @Nullable
    private BlockPos restrictPos1 = null;
    @Nullable
    private BlockPos restrictPos2 = null;

    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.restrictEnabled = buf.readBoolean();
        this.restrictPos1 = (BlockPos)buf.m_236868_(FriendlyByteBuf::m_130135_);
        this.restrictPos2 = (BlockPos)buf.m_236868_(FriendlyByteBuf::m_130135_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new RestrictableModuleWindow(this, MineColoniesCompatibility.rl("gui/layouthuts/layoutrestrictable.xml"));
    }

    public String getIcon() {
        return "restrict";
    }

    public Component getDesc() {
        return DESC;
    }

    @Override
    public void setRestrictEnabled(boolean enabled) {
        this.restrictEnabled = enabled;
        MineColoniesCompatibility.network().sendToServer((AbstractMessage)new RestrictSetEnabledMessage(this, enabled));
    }

    @Override
    public void setRestrictArea(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        this.restrictPos1 = pos1;
        this.restrictPos2 = pos2;
        MineColoniesCompatibility.network().sendToServer((AbstractMessage)new RestrictSetAreaMessage(this, pos1, pos2));
    }

    @Override
    public boolean isRestrictEnabled() {
        return this.restrictEnabled;
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos1() {
        BlockPos pos1 = this.restrictPos1;
        return pos1 != null ? pos1 : this.getBuildingView().getPosition();
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos2() {
        BlockPos pos2 = this.restrictPos2;
        return pos2 != null ? pos2 : this.getBuildingView().getPosition();
    }
}

