/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.api.common.building.module.NetworkStorageViewRegistry;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModuleView;
import steve_gall.minecolonies_compatibility.core.common.network.message.NetworkStorageRefreshMessage;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class NetworkStorageModuleWindow
extends AbstractModuleWindow<NetworkStorageModuleView> {
    public static final Component TEXT_REFRESH = Component.m_237115_((String)"minecolonies_compatibility.text.refresh");
    public static final Component TEXT_REFRESHING = Component.m_237115_((String)"minecolonies_compatibility.text.refreshing");
    private static final String BUTTON_REFRESH = "refresh";
    protected final NetworkStorageModuleView module;
    protected final ScrollingList resourceList;
    private int refreshTicks;
    private int revision;
    private List<ViewCache> currentDisplayedList;

    public NetworkStorageModuleWindow(NetworkStorageModuleView module, ResourceLocation res) {
        super((IBuildingModuleView)module, res);
        this.module = module;
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
    }

    public void onOpened() {
        super.onOpened();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.refreshTicks > 0) {
            --this.refreshTicks;
            if (this.refreshTicks % 20 == 0) {
                MineColoniesCompatibility.network().sendToServer((AbstractMessage)new NetworkStorageRefreshMessage(this.module));
            }
            if (this.refreshTicks == 0) {
                Button button = (Button)this.findPaneOfTypeByID(BUTTON_REFRESH, Button.class);
                button.setEnabled(true);
                button.setText(TEXT_REFRESH);
            }
        }
        if (this.revision != this.module.getRevision()) {
            this.updateResources();
        }
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (button.getID().equals(BUTTON_REFRESH)) {
            MineColoniesCompatibility.network().sendToServer((AbstractMessage)new NetworkStorageRefreshMessage(this.module));
            button.setEnabled(false);
            button.setText(TEXT_REFRESHING);
            this.refreshTicks = 80;
        }
    }

    protected void updateResources() {
        NetworkStorageModuleView module = this.module;
        this.revision = module.getRevision();
        Level level = module.getBuildingView().getColony().getWorld();
        this.currentDisplayedList = new ArrayList<ViewCache>();
        for (BlockPos pos : module.getBlocks()) {
            Direction direction = module.getDirection(pos);
            this.currentDisplayedList.add(new ViewCache(level, pos, direction));
        }
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return NetworkStorageModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ViewCache cache = NetworkStorageModuleWindow.this.currentDisplayedList.get(index);
                ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
                icon.setItem(cache.icon);
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                nameLabel.setText(cache.name);
                Text posLabel = (Text)rowPane.findPaneOfTypeByID("pos", Text.class);
                posLabel.setText(cache.posText);
            }
        });
    }

    public NetworkStorageModuleView getModule() {
        return this.module;
    }

    public class ViewCache {
        public final INetworkStorageView view;
        public final Component posText;
        public final ItemStack icon;
        public final Component name;

        public ViewCache(Level level, BlockPos pos, Direction direction) {
            BlockEntity blockEntity = level.m_7702_(pos);
            this.view = NetworkStorageViewRegistry.select(blockEntity, direction);
            this.posText = Component.m_237110_((String)"minecolonies_compatibility.text.pos", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            this.icon = this.view != null ? this.view.getIcon() : ItemStack.f_41583_;
            this.name = this.icon.m_41786_();
        }
    }
}

