/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.inventory;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.core.common.inventory.ContainerHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;

public abstract class MenuRecipeValidatorRecipe<RECIPE extends Recipe<CONTAINER>, CONTAINER extends Container>
implements IMenuRecipeValidator<RECIPE> {
    public static final String TAG_ID = "id";
    @NotNull
    protected final Level level;

    public MenuRecipeValidatorRecipe(@NotNull Level level) {
        this.level = level;
    }

    @Override
    public List<RECIPE> findAll(Container container, ServerPlayer player) {
        return this.level.m_7465_().m_44013_(this.getRecipeType()).stream().filter(recipe -> {
            if (this.test(recipe, container, player)) {
                return recipe.m_5598_() || !this.level.m_46469_().m_46207_(GameRules.f_46151_) || player.m_8952_().m_12709_(recipe) || player.m_7500_();
            }
            return false;
        }).toList();
    }

    protected abstract boolean test(RECIPE var1, Container var2, ServerPlayer var3);

    protected boolean matchesWithIngredientsCount(RECIPE recipe, CONTAINER container) {
        int inputsSize;
        if (!recipe.m_5818_(container, this.level)) {
            return false;
        }
        int ingredientsSize = recipe.m_7527_().size();
        return ingredientsSize == (inputsSize = ItemStackHelper.filterNotEmpty(ContainerHelper.getItemStacks(container)).size());
    }

    @Override
    public CompoundTag serialize(IFactoryController controller, RECIPE recipe) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_ID, recipe.m_6423_().toString());
        return tag;
    }

    @Override
    public RECIPE deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_(TAG_ID));
        return (RECIPE)((Recipe)this.level.m_7465_().m_44043_(recipeId).orElse(null));
    }

    public abstract RecipeType<RECIPE> getRecipeType();
}

