/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

public class GenericRecipeRegistry<C extends Container, T extends Recipe<C>> {
    private final RegistryObject<? extends RecipeType<? extends T>> type;
    public List<T> RECIPES = new ArrayList<T>();
    public static List<GenericRecipeRegistry<?, ?>> REGISTRIES = new ArrayList();

    public GenericRecipeRegistry(RegistryObject<? extends RecipeType<? extends T>> type) {
        this.type = type;
        REGISTRIES.add(this);
    }

    public List<T> getRecipes() {
        return Collections.unmodifiableList(this.RECIPES);
    }

    public RecipeType<? extends T> getType() {
        return (RecipeType)this.type.get();
    }

    public void reload(RecipeManager manager) {
        this.RECIPES.clear();
        List recipes = manager.m_44013_((RecipeType)this.type.get());
        this.RECIPES.addAll(recipes);
    }

    public static void reloadAll(RecipeManager recipeManager) {
        for (GenericRecipeRegistry<?, ?> registry : REGISTRIES) {
            registry.reload(recipeManager);
        }
    }
}

