/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.client.minecolonies;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ZoomDragView;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowResearchTree;
import com.minecolonies.core.client.gui.modules.UniversityModuleWindow;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigServer;
import steve_gall.minecolonies_tweaks.core.common.inventory.InventoryUtils2;
import steve_gall.minecolonies_tweaks.core.common.network.message.ResearchCostRequestMessage;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCost;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostResolver;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostSelector;

@Mixin(value={WindowResearchTree.class}, remap=false)
public abstract class WindowResearchTreeMixin
extends AbstractWindowSkeleton {
    @Unique
    private static final String minecolonies_tweaks$MISSING_COST_PREFIX = "missing_cost:";
    @Unique
    private static final String minecolonies_tweaks$REQUEST_PREFIX = "request:";
    @Shadow(remap=false)
    private UniversityModuleWindow last;
    @Shadow(remap=false)
    private IBuildingView building;
    @Shadow(remap=false)
    private ResourceLocation branch;
    @Shadow(remap=false)
    private ButtonImage undoButton;
    @Shadow(remap=false)
    private Text undoText;

    public WindowResearchTreeMixin(ResourceLocation resource) {
        super(resource);
    }

    @WrapOperation(method={"<init>"}, remap=false, at={@At(value="INVOKE", target="com/minecolonies/api/research/ILocalResearchTree.branchFinishedHighestLevel", remap=false)})
    private boolean init_branchFinishedHighestLevel(ILocalResearchTree tree, ResourceLocation branch, Operation<Boolean> operation) {
        if (this.mc.f_91074_.m_7500_() || ((Boolean)MCTweaksConfigServer.INSTANCE.researches.ignoreConstraints.get()).booleanValue()) {
            return false;
        }
        return (Boolean)operation.call(new Object[]{tree, branch});
    }

    @WrapOperation(method={"getResearchButtonState"}, remap=false, at={@At(value="INVOKE", target="com/minecolonies/api/research/IGlobalResearch.getDepth", remap=false)})
    private int getResearchButtonState_getDepth(IGlobalResearch research, Operation<Integer> operation) {
        if (this.mc.f_91074_.m_7500_()) {
            return 0;
        }
        return (Integer)operation.call(new Object[]{research});
    }

    @WrapOperation(method={"onButtonClicked", "generateResearchTooltips"}, remap=false, at={@At(value="INVOKE", target="com/minecolonies/api/research/IGlobalResearch.getDepth", remap=false)})
    private int onButtonClicked_getDepth(IGlobalResearch research, Operation<Integer> operation) {
        if (this.mc.f_91074_.m_7500_() || ((Boolean)MCTweaksConfigServer.INSTANCE.researches.ignoreConstraints.get()).booleanValue()) {
            return 0;
        }
        return (Integer)operation.call(new Object[]{research});
    }

    @WrapOperation(method={"getResearchButtonState"}, remap=false, at={@At(value="FIELD", target="hasMax:Z", remap=false)})
    private boolean getResearchButtonState_hasMax(WindowResearchTree self, Operation<Boolean> operation) {
        if (((Boolean)MCTweaksConfigServer.INSTANCE.researches.ignoreConstraints.get()).booleanValue()) {
            return false;
        }
        return (Boolean)operation.call(new Object[]{self});
    }

    @WrapOperation(method={"drawResearchItem", "drawArrows"}, remap=false, at={@At(value="INVOKE", target="com/minecolonies/api/research/IGlobalResearch.hasOnlyChild", remap=false)})
    private boolean drawResearchItem_hasOnlyChild(IGlobalResearch research, Operation<Boolean> operation) {
        if (this.mc.f_91074_.m_7500_() || ((Boolean)MCTweaksConfigServer.INSTANCE.researches.ignoreConstraints.get()).booleanValue()) {
            return false;
        }
        return (Boolean)operation.call(new Object[]{research});
    }

    @WrapOperation(method={"drawTreeBackground"}, remap=false, at={@At(value="INVOKE", target="com/minecolonies/api/colony/buildings/views/IBuildingView.getBuildingLevel", remap=false)})
    private int drawTreeBackground_getBuildingLevel(IBuildingView building, Operation<Integer> operation) {
        if (this.mc.f_91074_.m_7500_()) {
            return building.getBuildingMaxLevel();
        }
        return (Integer)operation.call(new Object[]{building});
    }

    @WrapOperation(method={"generateResearchTooltips", "getResearchButtonState", "onButtonClicked"}, remap=false, at={@At(value="NEW", target="net/minecraftforge/items/wrapper/InvWrapper", remap=false)})
    private InvWrapper newInvWrapper(Container inv, Operation<InvWrapper> operation) {
        InvWrapper original = (InvWrapper)operation.call(new Object[]{inv});
        Level level = this.building.getColony().getWorld();
        if (level != null) {
            return InventoryUtils2.wrapWithBuilding(original, level, this.building.getPosition());
        }
        return original;
    }

    @Inject(method={"drawResearchBoxes"}, remap=false, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void drawResearchBoxes(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, @Coerce Object state, int progress, CallbackInfo ci, ButtonImage nameBar) {
        if (state.toString().equals("MISSING_COST")) {
            nameBar.setID(minecolonies_tweaks$MISSING_COST_PREFIX + research.getId().toString());
        }
    }

    @Inject(method={"onButtonClicked"}, remap=false, at={@At(value="TAIL")}, cancellable=false)
    private void onButtonClicked(Button button, CallbackInfo ci) {
        String buttonId = button.getID();
        if (buttonId.startsWith(minecolonies_tweaks$MISSING_COST_PREFIX)) {
            if (ResearchCostResolver.hasResolver(this.building)) {
                ResourceLocation researchId = new ResourceLocation(buttonId.substring(minecolonies_tweaks$MISSING_COST_PREFIX.length()));
                IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, researchId);
                this.minecolonies_tweaks$drawRequestButton(button, research);
            }
        } else if (buttonId.startsWith(minecolonies_tweaks$REQUEST_PREFIX)) {
            this.close();
            ResourceLocation branchId = this.branch;
            ResourceLocation researchId = new ResourceLocation(buttonId.substring(minecolonies_tweaks$REQUEST_PREFIX.length()));
            LocalPlayer player = this.mc.f_91074_;
            if (ResearchCost.isRequested(this.building, branchId, researchId)) {
                player.m_213846_((Component)Component.m_237115_((String)"minecolonies_tweaks.gui.already_requested").m_130940_(ChatFormatting.GRAY));
                SoundUtils.playErrorSound((Player)player, (BlockPos)this.building.getPosition());
            } else {
                IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(branchId, researchId);
                ResearchCostSelector.open((BOWindow)this.last, research, items -> MineColoniesTweaks.network().sendToServer(new ResearchCostRequestMessage(new BuildingPos(this.building), research.getBranch(), research.getId(), (List<ItemStorage>)items)));
            }
        }
    }

    @Unique
    private void minecolonies_tweaks$drawRequestButton(Button parent, IGlobalResearch research) {
        ButtonImage undoButton = this.undoButton;
        undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"), false);
        undoButton.setSize(129, 17);
        undoButton.setPosition(parent.getX() + 23, parent.getY() + 6 + 16);
        undoButton.setID(minecolonies_tweaks$REQUEST_PREFIX + research.getId().toString());
        parent.getParent().addChild((Pane)undoButton);
        Text undoText = this.undoText;
        undoText.setSize(129, 17);
        undoText.setPosition(parent.getX() + 5 + 23, parent.getY() + 6 + 16);
        undoText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        undoText.setText(Component.m_237115_((String)"minecolonies_tweaks.gui.request_research_cost"));
        undoText.disable();
        parent.getParent().addChild((Pane)undoText);
        AbstractTextBuilder.TooltipBuilder tooltip = PaneBuilders.tooltipBuilder().hoverPane((Pane)undoButton);
        ((AbstractTextBuilder.TooltipBuilder)tooltip.append(Component.m_237115_((String)"minecolonies_tweaks.gui.request_research_cost"))).bold();
        ((AbstractTextBuilder.TooltipBuilder)tooltip.paragraphBreak()).append(Component.m_237115_((String)"minecolonies_tweaks.gui.request_research_cost.desc"));
        if (ResearchCost.isRequested(this.building, research.getBranch(), research.getId())) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)tooltip.paragraphBreak()).append(Component.m_237115_((String)"minecolonies_tweaks.gui.already_requested"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
        }
        for (IResearchCost cost : research.getCostList()) {
            MutableComponent text = Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237110_((String)"com.minecolonies.coremod.research.limit.requirement", (Object[])new Object[]{cost.getCount(), cost.getTranslatedName()}));
            ((AbstractTextBuilder.TooltipBuilder)tooltip.paragraphBreak()).append(text);
        }
        tooltip.build();
    }
}

