/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.client.minecolonies;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.tileentities.AbstractTileEntityScarecrow;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.containers.WindowField;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldPlotResizeMessage;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_tweaks.core.client.gui.ViewOverrideExtension;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

@Mixin(value={WindowField.class}, remap=false)
public abstract class WindowFieldMixin
extends AbstractWindowSkeleton
implements ViewOverrideExtension {
    @Shadow(remap=false)
    private static String DIRECTIONAL_BUTTON_ID_PREFIX;
    @Unique
    private static final String minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX;
    @Unique
    private static final String minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX;
    @Unique
    private static final int minecolonies_tweaks$SHIFT_MULTIPLIER = 5;
    @Shadow(remap=false)
    private FarmField farmField;
    @Shadow(remap=false)
    @NotNull
    private AbstractTileEntityScarecrow tileEntityScarecrow;

    public WindowFieldMixin(ResourceLocation resource) {
        super(resource);
    }

    @Inject(method={"<init>"}, remap=false, at={@At(value="TAIL")})
    private void init(@NotNull AbstractTileEntityScarecrow tileEntityScarecrow, CallbackInfo ci) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.registerButton(minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX + dir.m_122433_(), this::minecolonies_tweaks$onDirectionalUpButtonClick);
            this.registerButton(minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX + dir.m_122433_(), this::minecolonies_tweaks$onDirectionalDownButtonClick);
        }
        this.registerButton(minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX + "all", this::minecolonies_tweaks$onAllUpButtonClick);
        this.registerButton(minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX + "all", this::minecolonies_tweaks$onAllDownButtonClick);
        this.updateAll();
    }

    @Override
    public void minecolonies_tweaks$onParse(View view, PaneParams params) {
        Loader.createFromXMLFile((ResourceLocation)MineColoniesTweaks.rl("gui/windowfield.xml"), (View)this);
    }

    @Unique
    private void minecolonies_tweaks$changRadius(Button button, String prefix, int delta) {
        if (this.farmField == null || !button.isEnabled()) {
            return;
        }
        String directionName = button.getID().replace(prefix, "");
        Optional<Direction> direction = Direction.Plane.HORIZONTAL.m_122557_().filter(f -> f.m_122433_().equals(directionName)).findFirst();
        if (direction.isPresent()) {
            this.minecolonies_tweaks$changRadius(direction.get(), delta);
        }
    }

    private void minecolonies_tweaks$changRadius(Direction direction, int delta) {
        if (Screen.m_96638_()) {
            delta *= 5;
        }
        int newRadius = Mth.m_14045_((int)(this.farmField.getRadius(direction) + delta), (int)1, (int)this.farmField.getMaxRadius());
        this.farmField.setRadius(direction, newRadius);
        Button arrowButton = (Button)this.findPaneOfTypeByID(DIRECTIONAL_BUTTON_ID_PREFIX + direction.m_122433_(), Button.class);
        arrowButton.setText(Component.m_237113_((String)String.valueOf(newRadius)));
        Network.getNetwork().sendToServer((IMessage)new FarmFieldPlotResizeMessage(this.tileEntityScarecrow.getCurrentColony(), newRadius, direction, this.farmField.getPosition()));
    }

    @Unique
    private void minecolonies_tweaks$onDirectionalUpButtonClick(Button button) {
        this.minecolonies_tweaks$changRadius(button, minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX, 1);
    }

    @Unique
    private void minecolonies_tweaks$onDirectionalDownButtonClick(Button button) {
        this.minecolonies_tweaks$changRadius(button, minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX, -1);
    }

    @Unique
    private void minecolonies_tweaks$onAllUpButtonClick(Button button) {
        Direction.Plane.HORIZONTAL.forEach(dir -> this.minecolonies_tweaks$changRadius((Direction)dir, 1));
    }

    @Unique
    private void minecolonies_tweaks$onAllDownButtonClick(Button button) {
        Direction.Plane.HORIZONTAL.forEach(dir -> this.minecolonies_tweaks$changRadius((Direction)dir, -1));
    }

    @Shadow(remap=false)
    public abstract void updateAll();

    @Inject(method={"updateButtons"}, remap=false, at={@At(value="TAIL")}, cancellable=true)
    private void updateButtons(CallbackInfo ci) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.minecolonies_tweaks$updateButton(minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX + dir.m_122433_());
            this.minecolonies_tweaks$updateButton(minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX + dir.m_122433_());
        }
        this.minecolonies_tweaks$updateButton(minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX + "all");
        this.minecolonies_tweaks$updateButton(minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX + "all");
    }

    @Unique
    private void minecolonies_tweaks$updateButton(String name) {
        Button button = (Button)this.findPaneOfTypeByID(name, Button.class);
        if (button == null) {
            return;
        }
        button.setEnabled(!Objects.isNull(this.farmField));
    }

    static {
        minecolonies_tweaks$DIRECTIONAL_UP_BUTTON_ID_PREFIX = DIRECTIONAL_BUTTON_ID_PREFIX + "up-";
        minecolonies_tweaks$DIRECTIONAL_DOWN_BUTTON_ID_PREFIX = DIRECTIONAL_BUTTON_ID_PREFIX + "down-";
    }
}

