/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.client.gui.ResourceScrollBookListWindow;
import steve_gall.minecolonies_tweaks.core.common.inventory.ResourceScrollBookInventoryMenu;

public class ItemResourceScrollBook
extends Item {
    public static final List<Component> TOOLTIPS = Arrays.asList(Component.m_237115_((String)"item.minecolonies_tweaks.resourcescroll_book.tooltip1"), Component.m_237115_((String)"item.minecolonies_tweaks.resourcescroll_book.tooltip2"));
    private final int slots;

    public ItemResourceScrollBook(Item.Properties properites, int slots) {
        super(properites.m_41487_(1));
        this.slots = slots;
    }

    public Container getContainer(ItemStack stack) {
        return new Container(stack);
    }

    public int getSlots() {
        return this.slots;
    }

    public void setItems(ItemStack stack, List<ItemStack> slots) {
        CompoundTag compound = stack.m_41698_("resourcebook");
        ListTag slotsTag = new ListTag();
        compound.m_128365_("slots", (Tag)slotsTag);
        int count = slots.size();
        int size = Math.max(count, this.slots);
        for (int i = 0; i < size; ++i) {
            ItemStack slot = i < count ? slots.get(i) : ItemStack.f_41583_;
            slotsTag.add((Object)slot.serializeNBT());
        }
    }

    public NonNullList<ItemStack> getItems(ItemStack stack) {
        CompoundTag compound = stack.m_41737_("resourcebook");
        NonNullList items = NonNullList.m_122780_((int)this.slots, (Object)ItemStack.f_41583_);
        if (compound != null) {
            ListTag slots = compound.m_128437_("slots", 10);
            int size = slots.size();
            for (int i = 0; i < size; ++i) {
                CompoundTag slotTag = slots.m_128728_(i);
                ItemStack slot = ItemStack.m_41712_((CompoundTag)slotTag);
                items.set(i, (Object)slot);
            }
        }
        return items;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.addAll(TOOLTIPS);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_6144_()) {
                this.openInventory(serverPlayer, stack, this.getHandSlot(player, context.m_43724_()));
            }
        } else if (!player.m_6144_()) {
            this.openWindow(stack);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_6144_()) {
                this.openInventory(serverPlayer, stack, this.getHandSlot(player, hand));
            }
        } else if (!player.m_6144_()) {
            this.openWindow(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void openWindow(ItemStack stack) {
        new ResourceScrollBookListWindow(null, (List<ItemStack>)this.getItems(stack)).open();
    }

    public void openInventory(ServerPlayer player, final ItemStack stack, final int slot) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return new ResourceScrollBookInventoryMenu(windowId, inventory, slot);
            }

            public Component m_5446_() {
                return stack.m_41786_();
            }
        }, buf -> buf.writeInt(slot));
    }

    public int getHandSlot(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return player.m_150109_().f_35977_;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return 40;
        }
        return -1;
    }

    public class Container
    implements net.minecraft.world.Container {
        private final ItemStack stack;
        private final List<ItemStack> items;

        public Container(ItemStack stack) {
            this.stack = stack;
            this.items = ItemResourceScrollBook.this.getItems(stack);
        }

        public int m_6893_() {
            return 1;
        }

        public void m_6211_() {
            for (int i = 0; i < this.m_6643_(); ++i) {
                this.items.set(i, ItemStack.f_41583_);
            }
            this.m_6596_();
        }

        public int m_6643_() {
            return ItemResourceScrollBook.this.getSlots();
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return this.items.get(slot);
        }

        public ItemStack m_7407_(int slot, int count) {
            ItemStack stack = ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
            if (!stack.m_41619_()) {
                this.m_6596_();
            }
            return stack;
        }

        public ItemStack m_8016_(int slot) {
            ItemStack stack = this.items.get(slot);
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.items.set(slot, ItemStack.f_41583_);
            return stack;
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.items.set(slot, stack);
            int maxStackSize = this.m_6893_();
            if (!stack.m_41619_() && stack.m_41613_() > maxStackSize) {
                stack.m_41764_(maxStackSize);
            }
            this.m_6596_();
        }

        public void m_6596_() {
            ItemResourceScrollBook.this.setItems(this.stack, this.items);
        }

        public boolean m_6542_(Player player) {
            return false;
        }
    }
}

