/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building.module;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostResolver;

public class ResearchCostResolverBuildingModule
extends AbstractBuildingModule
implements ICreatesResolversModule {
    public List<IRequestResolver<?>> createResolvers() {
        ILocation location = this.getBuilding().getLocation();
        return Arrays.asList(new ResearchCostResolver(location, (IToken)this.getBuilding().getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    public boolean hasResolver() {
        for (IRequestResolver resolver : this.getBuilding().getResolvers()) {
            if (!(resolver instanceof ResearchCostResolver)) continue;
            return true;
        }
        return false;
    }

    public void serializeToView(FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.hasResolver());
    }

    public static class View
    extends AbstractBuildingModuleView {
        private boolean hasResolver;

        public void deserialize(@NotNull FriendlyByteBuf buf) {
            this.hasResolver = buf.readBoolean();
        }

        public boolean hasResolver() {
            return this.hasResolver;
        }

        public boolean isPageVisible() {
            return false;
        }

        public BOWindow getWindow() {
            return null;
        }

        public String getIcon() {
            return null;
        }

        public Component getDesc() {
            return null;
        }
    }
}

